/**
 * @(#) SysParamEo.java 1.0 2019-10-26
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;


/**
 * 业务参数删除Dto
 *
 * @author 黑马
 * @since 1.0.0
 */
@ApiModel(value = "SysParamDelReqDto", description = "业务参数删除Dto")
public class SysParamDelReqDto extends BaseReqDto {
    private static final long serialVersionUID = 5529877548102659595L;

    /**
     * 编码
     */
    @ApiModelProperty(value = "编码")
    @NotNull(message = "编码不能为空")
    private String code;

    @ApiModelProperty(value = "实例ID")
    private Long instanceId;

    @ApiModelProperty(value = "租户ID")
    private Long tenantId;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public Long getInstanceId() {
        return instanceId;
    }

    @Override
    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    @Override
    public Long getTenantId() {
        return tenantId;
    }

    @Override
    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }
}
