/**
 * @(#)SysParamItemModifyReqDto 1.0 2019/11/9
 * <p>
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.Pattern;

/**
 * @author shuangqing  2019/11/9
 */
@ApiModel(value = "SysParamItemModifyDto", description = "修改参数选项dto")
public class SysParamItemModifyDto extends BaseVo {

    /**
     * 业务参数选项编码
     */
    @ApiModelProperty(value = "业务参数选项编码")
    private String itemCode;

    /**
     * 排序号
     */
    @ApiModelProperty(value = "排序号")
    private Integer sortNo;

    /**
     * 参数值描述
     */
    @Pattern(regexp = "^.{0,20}$", message = "长度不能超过20个字符")
    @ApiModelProperty(value = "参数值描述")
    private String valueDesc;

    /**
     * 参数值
     */
    @Pattern(regexp = "^.{0,20}$", message = "长度不能超过20个字符")
    @ApiModelProperty(value = "参数值")
    private String paramValue;

    /**
     * 备注
     */
    @Pattern(regexp = "^.{0,200}$", message = "长度不能超过200个字符")
    @ApiModelProperty(value = "备注")
    private String remark;

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public Integer getSortNo() {
        return sortNo;
    }

    public void setSortNo(Integer sortNo) {
        this.sortNo = sortNo;
    }

    public String getValueDesc() {
        return valueDesc;
    }

    public void setValueDesc(String valueDesc) {
        this.valueDesc = valueDesc;
    }

    public String getParamValue() {
        return paramValue;
    }

    public void setParamValue(String paramValue) {
        this.paramValue = paramValue;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}
