/**
 * @(#) SysParamEo.java 1.0 2019-10-26
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.util.List;


/**
 * 业务参数修改Dto
 *
 * @author 黑马
 * @since 1.0.0
 */
@ApiModel(value = "SysParamModifyReqDto", description = "业务参数修改Dto")
public class SysParamModifyReqDto extends BaseReqDto {
    private static final long serialVersionUID = -6853020148536839206L;

    /**
     * 编码
     */
    @ApiModelProperty(value = "编码")
    @Pattern(regexp = "^[a-zA-Z][0-9a-zA-Z\\w.]{0,200}$", message = "编码只能字母开头,只支持字母，数字，下划线，点号组合字符，长度不能超过200个字符")
    @NotNull(message = "编码不能为空")
    private String code;

    /**
     * 名称
     */
    @Pattern(regexp = "^[\\u4E00-\\u9FA5\\w]{0,50}$", message = "能力名称只能为字母，下划线，数字，中文组合且长度不能超过50个字符")
    @ApiModelProperty(value = "名称")
    private String name;

    /**
     * 描述
     */
    @Pattern(regexp = "^.{0,200}$", message = "业务参数简介description长度不能超过200个字符")
    @ApiModelProperty(value = "描述")
    private String description;

    /**
     * 级别(0:全局;1:租户;2:应用)
     */
    @Min(value = 0, message = "级别grade只支持[0:全局;1:租户;2:应用]")
    @Max(value = 2, message = "级别grade只支持[0:全局;1:租户;2:应用]")
    @ApiModelProperty(value = "级别(0:全局;1:租户;2:应用)")
    private Integer grade;

    /**
     * 选择类型(0:输入;1:单选;2:多选)
     */
    @Min(value = 0, message = "选择类型selectType只支持[0:输入;1:单选;2:多选]")
    @Max(value = 2, message = "选择类型selectType只支持[0:输入;1:单选;2:多选]")
    @ApiModelProperty(value = "选择类型(0:输入;1:单选;2:多选)")
    private Integer selectType;

    /**
     * 默认值
     */
    @ApiModelProperty(value = "默认值")
    private String defaultValue;

    /**
     * 值类型(0:文本;1:数值;2:布尔;3:日期)
     */
    @Min(value = 0, message = "值类型valueType只支持[0:文本;1:整型;2:布尔;3:日期;4:浮点]")
    @Max(value = 4, message = "值类型valueType只支持[0:文本;1:整型;2:布尔;3:日期;4:浮点]")
    @ApiModelProperty(value = "值类型(0:文本;1:数值;2:布尔;3:日期;4:浮点)")
    private Integer valueType;

    /**
     * 所属分组
     */
    @ApiModelProperty(value = "所属分组")
    private String groupCode;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;


    /**
     * 能力编码
     */
    @ApiModelProperty(value = "能力编码")
    private List<String> abilityCodes;

    @ApiModelProperty(value = "业务参数选项编码")
    private List<SysParamItemModifyDto> sysParamItemModifyDtos;

    public List<SysParamItemModifyDto> getSysParamItemModifyDtos() {
        return sysParamItemModifyDtos;
    }

    public void setSysParamItemModifyDtos(List<SysParamItemModifyDto> sysParamItemModifyDtos) {
        this.sysParamItemModifyDtos = sysParamItemModifyDtos;
    }

    public List<String> getAbilityCodes() {
        return abilityCodes;
    }

    public void setAbilityCodes(List<String> abilityCodes) {
        this.abilityCodes = abilityCodes;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getGrade() {
        return grade;
    }

    public void setGrade(Integer grade) {
        this.grade = grade;
    }

    public Integer getSelectType() {
        return selectType;
    }

    public void setSelectType(Integer selectType) {
        this.selectType = selectType;
    }

    public String getDefaultValue() {
        return defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Integer getValueType() {
        return valueType;
    }

    public void setValueType(Integer valueType) {
        this.valueType = valueType;
    }

    public String getGroupCode() {
        return groupCode;
    }

    public void setGroupCode(String groupCode) {
        this.groupCode = groupCode;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}
