package com.dtyunxi.yundt.cube.center.func.api.dto.request.bizid;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.util.List;

/**
 * 业务空间和业务身份关系Eo对象
 *
 * @author 代码生成器
 */
@ApiModel(value = "BizConfigReqDto", description = "设置业务空间和业务身份下的配置项")
public class BizConfigReqDto extends RequestDto {

    /**
     * type类型：1是业务参数,2是扩展点
     */
    @NotNull(message = "type类型不能为null")
    @ApiModelProperty(value = "type类型：1是业务参数,2是扩展点")
    private Integer type;

    /**
     * 业务参数code或扩展点code
     */
    @NotBlank(message = "业务参数code或扩展点code")
    @ApiModelProperty(value = "业务参数code或扩展点code")
    private String code;

    /**
     * 配置值
     */
    @NotNull(message = "配置值不能为空")
    @Size(min = 1, message = "配置值不能为空")
    @ApiModelProperty(value = "配置值")
    private List<String> values;

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public List<String> getValues() {
        return values;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }
}