package com.dtyunxi.yundt.cube.center.func.api.dto.request.bizid;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.util.List;

/**
 * 业务空间和业务身份关系Eo对象
 *
 * @author 代码生成器
 */
@ApiModel(value = "SpaceIdConfigsReqDto", description = "业务空间和业务身份配置对象")
public class SpaceIdConfigsReqDto extends RequestDto {

    /**
     * 业务空间编码
     */
    @NotBlank(message = "业务空间编码不能为空")
    @ApiModelProperty(value = "业务空间编码", required = true)
    private String spaceCode;

    /**
     * 业务身份编码
     */
    @NotBlank(message = "业务身份编码不能为空")
    @ApiModelProperty(value = "业务身份编码", required = true)
    private String idCode;

    /**
     * 配置项
     */
    @Size(min = 1, message = "配置项最少有一个")
    @ApiModelProperty(value = "配置项")
    @Valid
    private List<BizConfigReqDto> configs;

    @Override
    public Long getTenantId() {
        return super.getTenantId();
    }


    public String getSpaceCode() {
        return spaceCode;
    }

    public void setSpaceCode(String spaceCode) {
        this.spaceCode = spaceCode;
    }

    public String getIdCode() {
        return idCode;
    }

    public void setIdCode(String idCode) {
        this.idCode = idCode;
    }

    public List<BizConfigReqDto> getConfigs() {
        return configs;
    }

    public void setConfigs(List<BizConfigReqDto> configs) {
        this.configs = configs;
    }
}