package com.dtyunxi.yundt.cube.center.func.api.dto.request.bizid;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotBlank;

@ApiModel(value = "SpaceIdQueryReqDto", description = "业务空间和业务身份下")
public class SpaceIdQueryReqDto extends RequestDto {
    /**
     * 名称
     */
    @NotBlank(message = "业务身份编码不能为空")
    @ApiModelProperty(value = "业务身份编码", required = true)
    private String bizIdCode;
    /**
     * 名称
     */
    @ApiModelProperty(value = "名称")
    private String name;
    /**
     * 业务空间编码
     */
    @ApiModelProperty(value = "业务空间编码")
    private String code;

    @Override
    public Long getTenantId() {
        return super.getTenantId();
    }

    public String getBizIdCode() {
        return bizIdCode;
    }

    public void setBizIdCode(String bizIdCode) {
        this.bizIdCode = bizIdCode;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }


}




