package com.dtyunxi.yundt.cube.center.func.api.dto.request.bizobj;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;

/**
 * 业务对象Eo对象
 *
 * @author 代码生成器
 */
public class BizObjReqDto extends RequestDto {

    /**
     * 编码
     */
    @NotNull(message = "编码不能为null")
    @Size(min = 1, max = 200, message = "编码长度不能超过200个字符")
    @Pattern(regexp = "([a-zA-Z][a-zA-Z\\d_]*\\.)*[a-zA-Z_][a-zA-Z\\d_]*", message = "编码只能字母开头，只支持字母，数字，下划线，点号组合字符")
    @ApiModelProperty(value = "编码")
    private String code;

    /**
     * 名称
     */
    @NotNull(message = "名称不能为null")
    @Pattern(regexp = "^[\\u4E00-\\u9FA5\\w]{1,50}$", message = "名称只能为字母，下划线，数字，中文组合且长度不能超过50个字符")
    @ApiModelProperty(value = "名称")
    private String name;

    /**
     * 领域编码
     */
    @ApiModelProperty(value = "领域编码")
    private String abilityGroupCode;

    /**
     * 状态：0 禁用  1启用
     */
    @NotNull(message = "状态不能为null")
    @Min(value = 0, message = "状态只能为禁用或启用")
    @Max(value = 1, message = "状态只能为禁用或启用")
    @ApiModelProperty(value = "状态：0 禁用  1启用")
    private Integer status;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;

    /**
     * 属性列表
     */
    @Valid
    @NotEmpty(message = "属性列表不能为空")
    @ApiModelProperty(value = "属性列表")
    private List<BizObjPropertyReqDto> properties;

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAbilityGroupCode() {
        return this.abilityGroupCode;
    }

    public void setAbilityGroupCode(String abilityGroupCode) {
        this.abilityGroupCode = abilityGroupCode;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public List<BizObjPropertyReqDto> getProperties() {
        return properties;
    }

    public void setProperties(List<BizObjPropertyReqDto> properties) {
        this.properties = properties;
    }
}