/**
 * @(#)AbilityOverViewDto 1.0 2019/11/21
 * <p>
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.dto.response;

import com.dtyunxi.yundt.cube.center.func.api.constants.Constants;
import com.dtyunxi.yundt.cube.center.func.api.dto.TreeDtoBase;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.ITreeNode;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author shuangqing  2019/11/21
 */
@ApiModel(value = "AbilityOverviewDto", description = "能力地图返回dto")
public class AbilityOverviewDto extends TreeDtoBase implements ITreeNode<AbilityOverviewDto> {

    @ApiModelProperty(value = "文档id:只有领域、场景才有值")
    private Long docId;

    @ApiModelProperty(value = "文档名称:只有领域、场景才有值")
    private String docName;

    @ApiModelProperty(value = "文档简介:只有领域、场景才有值")
    private String brief;

    @ApiModelProperty(value = "文档正文:只有领域、场景才有值")
    private String content;

    @ApiModelProperty(value = "排序号")
    private Integer sort;

    @ApiModelProperty(value = "文档更新时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date docUpdateTime;

    /**
     * 前端要求统一用selectType,  去掉扩展点的bext_type
     * 只有业务参数、扩展点，这个字段才有值
     */
    @Deprecated
    @ApiModelProperty(value = "(已废弃)业务参数的选择类型(0:输入;1:单选;2:多选) ; 扩展点类型:  1: 单实现生效  2:并行实现生效；" +
            "只有业务参数、扩展点，这个字段才有值")
    private Integer selectType;

    @Deprecated
    @ApiModelProperty(value = "（已废弃）业务参数选项值")
    private String paramValue;

    @Deprecated
    @ApiModelProperty(value = "（已废弃）业务参数默认值")
    private String defaultValue;

    @ApiModelProperty(value = "子节点")
    private List<AbilityOverviewDto> children = new ArrayList<>();

    public Date getDocUpdateTime() {
        return docUpdateTime;
    }

    public void setDocUpdateTime(Date docUpdateTime) {
        this.docUpdateTime = docUpdateTime;
    }

    public Long getDocId() {
        return docId;
    }

    public void setDocId(Long docId) {
        this.docId = docId;
    }

    public String getDocName() {
        return docName;
    }

    public void setDocName(String docName) {
        this.docName = docName;
    }

    public String getBrief() {
        return brief;
    }

    public void setBrief(String brief) {
        this.brief = brief;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getParamValue() {
        return paramValue;
    }

    public void setParamValue(String paramValue) {
        this.paramValue = paramValue;
    }

    public Integer getSort() {
        return sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public Integer getSelectType() {
        return selectType;
    }

    public void setSelectType(Integer selectType) {
        this.selectType = selectType;
    }


    public String getDefaultValue() {
        return defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public List<AbilityOverviewDto> getChildren() {
        return children;
    }

    @Override
    public void setChildren(List<AbilityOverviewDto> children) {
        this.children = children;
    }

    @Override
    public String getKey() {
        return this.getCode();
    }

    @Override
    public String getParentKey() {
        return this.getParentCode();
    }

    @Override
    public Boolean isRootNode() {
        return Constants.ROOT_NODE_PARENT_CODE.equals(this.getParentCode());
    }

    @Override
    public void addChild(AbilityOverviewDto iTreeNode) {
        children.add(iTreeNode);
    }

    @Override
    public int compareTo(ITreeNode node) {
        return this.getKey().compareTo(node.getKey());
    }
}
