/**
 * @(#) AppInstanceDtoQueryRespDto.java 1.0 2020-05-07
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.func.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 应用授权DTO清单响应dto
 *
 * @author 仪琳
 * @since 1.0.0
 */
@ApiModel(value = "AppInstanceDtoQueryRespDto", description = "应用授权DTO清单响应dto")
public class AppInstanceDtoQueryRespDto {

    @ApiModelProperty(value = "api名称")
    private String apiName;

    @ApiModelProperty(value = "接口URL")
    private String path;

    /**
     * 业务空间编码
     */
    @ApiModelProperty(value = "业务空间编码")
    private String bizSpaceCode;

    /**
     * 业务空间名称
     */
    @ApiModelProperty(value = "业务空间名称")
    private String bizSpaceName;

    @ApiModelProperty(value = "应用编码")
    private String appCode;

    @ApiModelProperty(value = "应用名称")
    private String appInsName;

    @ApiModelProperty(value = "DTO编码")
    private String dtoCode;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "DTO属性列表")
    private List<AppInstanceDtoTreeRespDto> children;

    public String getApiName() {
        return apiName;
    }

    public void setApiName(String apiName) {
        this.apiName = apiName;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getBizSpaceCode() {
        return bizSpaceCode;
    }

    public void setBizSpaceCode(String bizSpaceCode) {
        this.bizSpaceCode = bizSpaceCode;
    }

    public String getBizSpaceName() {
        return bizSpaceName;
    }

    public void setBizSpaceName(String bizSpaceName) {
        this.bizSpaceName = bizSpaceName;
    }

    public String getAppCode() {
        return appCode;
    }

    public void setAppCode(String appCode) {
        this.appCode = appCode;
    }

    public String getAppInsName() {
        return appInsName;
    }

    public void setAppInsName(String appInsName) {
        this.appInsName = appInsName;
    }

    public List<AppInstanceDtoTreeRespDto> getChildren() {
        return children;
    }

    public void setChildren(List<AppInstanceDtoTreeRespDto> children) {
        this.children = children;
    }

    public String getDtoCode() {
        return dtoCode;
    }

    public void setDtoCode(String dtoCode) {
        this.dtoCode = dtoCode;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}
