/**
 * @(#) AppInstanceDtoTreeRespDto.java 1.0 2020-05-07
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.func.api.dto.response;

import com.dtyunxi.yundt.cube.center.func.api.dto.base.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * @author 仪琳
 * @since 1.0.0
 */
@ApiModel(value = "AppInstanceDtoTreeRespDto", description = "应用授权DTO响应属性dto")
public class AppInstanceDtoTreeRespDto extends BaseRespDto {

    @ApiModelProperty(value = "父属性编码")
    private String parentCode;

    @ApiModelProperty(value = "属性编码")
    private String propertyCode;

    @ApiModelProperty(value = "属性名称")
    private String name;

    @ApiModelProperty(value = "数据类型")
    private String dataType;

    @ApiModelProperty(value = "父权限id")
    private Long parentId;

    @ApiModelProperty(value = "属性层级")
    private Integer hierarchy;

    @ApiModelProperty(value = "授权状态，0未授权，1授权")
    private Integer status;

    @ApiModelProperty(value = "DTO子属性列表")
    private List<AppInstanceDtoTreeRespDto> children;


    public String getParentCode() {
        return parentCode;
    }

    public void setParentCode(String parentCode) {
        this.parentCode = parentCode;
    }

    public String getPropertyCode() {
        return propertyCode;
    }

    public void setPropertyCode(String propertyCode) {
        this.propertyCode = propertyCode;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDataType() {
        return dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Integer getHierarchy() {
        return hierarchy;
    }

    public void setHierarchy(Integer hierarchy) {
        this.hierarchy = hierarchy;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public List<AppInstanceDtoTreeRespDto> getChildren() {
        return children;
    }

    public void setChildren(List<AppInstanceDtoTreeRespDto> children) {
        this.children = children;
    }
}
