package com.dtyunxi.yundt.cube.center.func.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * 扩展点实现返回Dto
 *
 * @author youyang
 * @date 2019/10/30
 * @since 2.6.21.0
 */
@ApiModel(value = "BizExtImplRespDto", description = "扩展点实现返回Dto")
public class BizExtImplRespDto extends BaseRespDto {

    private static final long serialVersionUID = 1L;

    /**
     * 扩展点代码
     */
    @ApiModelProperty(value = "扩展点代码")
    private String bextCode;
    /**
     * 扩展点实现代码
     */
    @ApiModelProperty(value = "扩展点实现代码")
    private String bextImplCode;

    /**
     * 扩展点实现简称
     */
    @ApiModelProperty(value = "扩展点实现简称")
    private String bextImplName;
    /**
     * 扩展点实现描述
     */
    @ApiModelProperty(value = "扩展点实现描述")
    private String bextImplDesc;
    /**
     * 排序号
     */
    @ApiModelProperty(value = "排序号")
    private Integer sortNo;
    /**
     * 影响的应用系统
     * 提供扩展点实现的系统,多个有英文半角逗号分隔
     */
    @ApiModelProperty(value = "影响的应用系统")
    private String effectApp;
    /**
     * 当前版本
     */
    @ApiModelProperty(value = "当前版本")
    private String curVer;
    /**
     * 当前版本注册时间
     */
    @ApiModelProperty(value = "当前版本注册时间")
    private Date curVerReleaseTime;
    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;

    public String getBextImplName() {
        return bextImplName;
    }

    public void setBextImplName(String bextImplName) {
        this.bextImplName = bextImplName;
    }

    public String getBextCode() {
        return bextCode;
    }

    public void setBextCode(String bextCode) {
        this.bextCode = bextCode;
    }

    public String getBextImplCode() {
        return bextImplCode;
    }

    public void setBextImplCode(String bextImplCode) {
        this.bextImplCode = bextImplCode;
    }

    public String getBextImplDesc() {
        return bextImplDesc;
    }

    public void setBextImplDesc(String bextImplDesc) {
        this.bextImplDesc = bextImplDesc;
    }

    public Integer getSortNo() {
        return sortNo;
    }

    public void setSortNo(Integer sortNo) {
        this.sortNo = sortNo;
    }

    public String getEffectApp() {
        return effectApp;
    }

    public void setEffectApp(String effectApp) {
        this.effectApp = effectApp;
    }

    public String getCurVer() {
        return curVer;
    }

    public void setCurVer(String curVer) {
        this.curVer = curVer;
    }

    public Date getCurVerReleaseTime() {
        return curVerReleaseTime;
    }

    public void setCurVerReleaseTime(Date curVerReleaseTime) {
        this.curVerReleaseTime = curVerReleaseTime;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}
