/**
 * @(#)BundleRespDto 1.0 2020/2/28
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.dto.response;

import com.dtyunxi.yundt.cube.center.func.api.constants.Constants;
import com.dtyunxi.yundt.cube.center.func.api.dto.base.BundleBaseDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.ITreeNode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 功能包查询响应DTO
 *
 * @author 代码生成器
 */
@ApiModel(value = "BundleRespDto", description = "功能包查询响应DTO")
public class BundleRespDto extends BundleBaseDto implements ITreeNode<BundleRespDto> {

    /**
     * 主键ID
     */
    @ApiModelProperty(value = "主键ID")
    private Long id;

    /**
     * 功能包下的模块级功能包列表
     */
    @ApiModelProperty(value = "功能包下的模块级功能包列表")
    private List<BundleRespDto> children;

    /**
     * 功能包下的模块级功能包列表
     */
    @ApiModelProperty(value = "父级功能包名称")
    private String parent;

    @ApiModelProperty(value = "应用关联数")
    private Integer relateAppNo;

    @ApiModelProperty(value = "模块关联数")
    private Integer relateModuleNo;

    public Integer getRelateAppNo() {
        return relateAppNo;
    }

    public void setRelateAppNo(Integer relateAppNo) {
        this.relateAppNo = relateAppNo;
    }

    public Integer getRelateModuleNo() {
        return relateModuleNo;
    }

    public void setRelateModuleNo(Integer relateModuleNo) {
        this.relateModuleNo = relateModuleNo;
    }

    public String getParent() {
        return parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    @Override
    public List<BundleRespDto> getChildren() {
        return children;
    }

    @Override
    public void setChildren(List<BundleRespDto> children) {
        this.children = children;
    }

    @Override
    public String getKey() {
        return this.getCode();
    }

    @Override
    public String getParentKey() {
        return this.getParentCode();
    }

    @Override
    public Boolean isRootNode() {
        return Constants.ROOT_NODE_PARENT_CODE.equals(this.getParentCode());
    }

    @Override
    public void addChild(BundleRespDto iTreeNode) {
        children.add(iTreeNode);
    }

}