/**
 * @(#)SettingValueTreeRespDto 1.0 2020/3/20
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.dto.response;

import com.dtyunxi.yundt.cube.center.data.dto.TabularDto;
import com.dtyunxi.yundt.cube.center.func.api.constants.Constants;
import com.dtyunxi.yundt.cube.center.func.api.dto.base.BaseRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.ITreeNode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * @author shuangqing  2020/3/20
 */
@ApiModel(value = "BundleSettingTreeRespDto", description = "功能包素材管理-配置值展示返回dto")
public class BundleSettingTreeRespDto extends BaseRespDto implements ITreeNode<BundleSettingTreeRespDto> {
    /**
     * 编码
     */
    @ApiModelProperty(value = "编码")
    private String code;

    /**
     * 名称
     */
    @ApiModelProperty(value = "类型：0 领域 1 能力 2 配置项 3 配置候选项")
    private Integer type;

    /**
     * 名称
     */
    @ApiModelProperty(value = "名称")
    private String name;


    /**
     * 配置项的值编辑方式
     */
    @ApiModelProperty(value = "配置项的值编辑方式")
    private Integer editType;

    /**
     * 配置项的值类型
     */
    @ApiModelProperty(value = "配置项的值类型")
    private Integer valueType;

    /**
     * 配置视图是否可见 1 是 0 否
     */
    @ApiModelProperty(value = "配置视图是否可见 1 是 0 否 默认1")
    private Integer viewVisible;

    /**
     * 是否允许多选  0 不允许  1 允许
     */
    @ApiModelProperty(value = "是否允许多选  0 不允许  1 允许")
    private Integer isMultiChoice;

    /**
     * 输入类型配置项的值
     */
    @ApiModelProperty(value = "输入类型配置项的值")
    private String settingValue;

    /**
     * 表示是否控制下级，如果为 1，则下级不允许修改；0 否 1 是；返回null表示当前级别不能修改该配置项
     */
    @ApiModelProperty(value = "表示是否控制下级，如果为 1，则下级不允许修改；0 否 1 是；返回null表示当前级别不能修改该配置项")
    private Integer isControlled;


    /**
     * 配置项已选中的候选项编码
     */
    @ApiModelProperty(value = "配置项已选中的候选项编码")
    private List<String> optionCodes;


    /**
     * 视图页面的表格类型配置项提交
     */
    @ApiModelProperty(value = "视图页面的表格类型配置项提交")
    private TabularDto tabularViewDto;

    /**
     * 简介
     */
    @ApiModelProperty(value = "简介")
    private String remark;

    /**
     * 父编码
     */
    @ApiModelProperty(value = "父编码")
    private String parentCode;

    /**
     * 子节点
     */
    @ApiModelProperty(value = "子节点")
    private List<BundleSettingTreeRespDto> children;

    /**
     * 标记配置项选项是否有引用其他配置项: 1 表示有联动配置项  0 表示无联动配置项
     */
    @ApiModelProperty(value = "标记配置项选项是否有引用其他配置项: 1 表示有联动配置项  0 表示无联动配置项")
    private Integer withDepdSetting;

    /**
     * 业务参数类型的配置项（非扩展点）的子类型：0 表示非形参  1 表示形参
     */
    @ApiModelProperty(value = "业务参数类型的配置项（非扩展点）的子类型：0 表示非形参  1 表示形参")
    private Integer paramSettingSubType;

    /**
     * 是否是非形参且被其他配置项引用： 0 否 1 是
     */
    @ApiModelProperty(value = "是否是非形参且被其他配置项引用： 0 否 1 是")
    private Integer isRefForOtherSetting;

    /**
     * 配置项参数，例如领域事件的topic、tag、dto编码等
     */
    @ApiModelProperty(value = "配置项参数，例如领域事件的topic、tag、dto编码等")
    private String parameter;

    /**
     * 领域事件发送开关，0 关闭，1开启
     */
    @ApiModelProperty(value = "领域事件发送开关，0 关闭，1开启")
    private Integer sendFlag;

    public Integer getIsRefForOtherSetting() {
        return isRefForOtherSetting;
    }

    public void setIsRefForOtherSetting(Integer isRefForOtherSetting) {
        this.isRefForOtherSetting = isRefForOtherSetting;
    }

    public Integer getParamSettingSubType() {
        return paramSettingSubType;
    }

    public void setParamSettingSubType(Integer paramSettingSubType) {
        this.paramSettingSubType = paramSettingSubType;
    }

    public Integer getViewVisible() {
        return viewVisible;
    }

    public void setViewVisible(Integer viewVisible) {
        this.viewVisible = viewVisible;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getParentCode() {
        return parentCode;
    }

    public void setParentCode(String parentCode) {
        this.parentCode = parentCode;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public List<String> getOptionCodes() {
        return optionCodes;
    }

    public void setOptionCodes(List<String> optionCodes) {
        this.optionCodes = optionCodes;
    }

    public Integer getIsMultiChoice() {
        return isMultiChoice;
    }

    public void setIsMultiChoice(Integer isMultiChoice) {
        this.isMultiChoice = isMultiChoice;
    }

    public Integer getEditType() {
        return editType;
    }

    public void setEditType(Integer editType) {
        this.editType = editType;
    }

    public Integer getValueType() {
        return valueType;
    }

    public void setValueType(Integer valueType) {
        this.valueType = valueType;
    }

    public String getSettingValue() {
        return settingValue;
    }

    public void setSettingValue(String settingValue) {
        this.settingValue = settingValue;
    }

    public Integer getIsControlled() {
        return isControlled;
    }

    public void setIsControlled(Integer isControlled) {
        this.isControlled = isControlled;
    }

    @Override
    public List<BundleSettingTreeRespDto> getChildren() {
        return children;
    }

    @Override
    public void setChildren(List<BundleSettingTreeRespDto> children) {
        this.children = children;
    }

    @Override
    public String getKey() {
        return this.getCode();
    }

    @Override
    public String getParentKey() {
        return this.getParentCode();
    }

    @Override
    public Boolean isRootNode() {
        return Constants.ROOT_NODE_PARENT_CODE.equals(this.getParentCode());
    }

    @Override
    public void addChild(BundleSettingTreeRespDto iTreeNode) {
        children.add(iTreeNode);
    }

    public Integer getWithDepdSetting() {
        return withDepdSetting;
    }

    public void setWithDepdSetting(Integer withDepdSetting) {
        this.withDepdSetting = withDepdSetting;
    }

    public TabularDto getTabularViewDto() {
        return tabularViewDto;
    }

    public void setTabularViewDto(TabularDto tabularViewDto) {
        this.tabularViewDto = tabularViewDto;
    }

    public String getParameter() {
        return parameter;
    }

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    public Integer getSendFlag() {
        return sendFlag;
    }

    public void setSendFlag(Integer sendFlag) {
        this.sendFlag = sendFlag;
    }
}
