package com.dtyunxi.yundt.cube.center.func.api.dto.response;


import com.dtyunxi.cube.utils.tree.ITreeNode;
import com.dtyunxi.yundt.cube.center.func.api.constants.Constants;
import com.dtyunxi.yundt.cube.center.func.api.dto.base.CapabilityBaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 能力列表返回参数
 *
 * @author shuangqing
 */
@ApiModel(value = "CapabilityRespDto", description = "能力列表返回参数")
public class CapabilityRespDto extends CapabilityBaseDto implements ITreeNode<CapabilityRespDto> {

    /**
     * 能力下的子能力列表
     */
    @ApiModelProperty(value = "能力下的子能力列表")
    private List<CapabilityRespDto> children;


    @Override
    public List<CapabilityRespDto> getChildren() {
        return children;
    }

    @Override
    public void setChildren(List<CapabilityRespDto> children) {
        this.children = children;
    }

    @Override
    public String getKey() {
        return this.getCode();
    }

    @Override
    public String getParentKey() {
        return this.getParentCode();
    }

    @Override
    public Boolean isRootNode() {
        return Constants.ROOT_NODE_PARENT_CODE.equals(this.getParentCode());
    }

    @Override
    public void addChild(CapabilityRespDto iTreeNode) {
        children.add(iTreeNode);
    }
}