package com.dtyunxi.yundt.cube.center.func.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import java.util.List;

/**
 * 文档详情结果dto
 */
@ApiModel(value = "DocDetailRespDto", description = "文档详情结果dto")
public class DocDetailRespDto extends BaseRespDto {

    /**
     * 文档名称
     */
    @ApiModelProperty(value = "文档名称")
    private String docName;

    /**
     * 能力分类编码
     */
    @Column(name = "ability_group_code")
    private String abilityGroupCode;

    /**
     * 简介
     */
    @ApiModelProperty(value = "简介")
    private String brief;

    /**
     * 内容
     */
    @ApiModelProperty(value = "内容")
    private String content;

    /**
     * 状态 : 0 下架  1 上架
     */
    @ApiModelProperty(value = "状态 : 0 下架  1 上架")
    private Integer status;

    /**
     * 关联API集合
     */
    @ApiModelProperty(value = "关联API集合")
    private List<ApiRespDto> apiRespDtos;

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getDocName() {
        return docName;
    }

    public String getAbilityGroupCode() {
        return abilityGroupCode;
    }

    public void setAbilityGroupCode(String abilityGroupCode) {
        this.abilityGroupCode = abilityGroupCode;
    }

    public void setDocName(String docName) {
        this.docName = docName;
    }

    public String getBrief() {
        return brief;
    }

    public void setBrief(String brief) {
        this.brief = brief;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public List<ApiRespDto> getApiRespDtos() {
        return apiRespDtos;
    }

    public void setApiRespDtos(List<ApiRespDto> apiRespDtos) {
        this.apiRespDtos = apiRespDtos;
    }
}
