/**
 * @(#)SettingRespDto 1.0 2020/2/28
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.dto.response;

import com.dtyunxi.yundt.cube.center.func.api.dto.base.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 查询能力下的配置项信息返回参数
 *
 * @author shuangqing  2020/2/28
 */
@ApiModel(value = "SettingRespDto", description = "查询能力下的配置项信息返回参数")
public class SettingRespDto extends BaseRespDto {

    /**
     * 配置项编码
     */
    @ApiModelProperty(value = "配置项编码")
    private String code;

    /**
     * 配置项名称
     */
    @ApiModelProperty(value = "配置项名称")
    private String name;

    /**
     * 配置项的来源功能包编码
     */
    @ApiModelProperty(value = "配置项的来源功能包编码")
    private String bundleCode;

    /**
     * 配置项的来源功能包名称
     */
    @ApiModelProperty(value = "配置项的来源功能包名称")
    private String bundleName;

    /**
     * 配置项的值编辑方式
     */
    @ApiModelProperty(value = "配置项的值编辑方式")
    private Integer editType;

    /**
     * 配置项的值类型
     */
    @ApiModelProperty(value = "配置项的值类型")
    private Integer valueType;

    /**
     * 配置项参数，例如领域事件的topic、tag、dto编码等
     */
    @ApiModelProperty(value = "配置项参数，例如领域事件的topic、tag、dto编码等")
    private String parameter;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBundleCode() {
        return bundleCode;
    }

    public void setBundleCode(String bundleCode) {
        this.bundleCode = bundleCode;
    }

    public String getBundleName() {
        return bundleName;
    }

    public void setBundleName(String bundleName) {
        this.bundleName = bundleName;
    }

    public Integer getEditType() {
        return editType;
    }

    public void setEditType(Integer editType) {
        this.editType = editType;
    }

    public Integer getValueType() {
        return valueType;
    }

    public void setValueType(Integer valueType) {
        this.valueType = valueType;
    }

    public String getParameter() {
        return parameter;
    }

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }
}
