/**
 * @(#) SysParamEo.java 1.0 2019-10-26
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.dto.response;

import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import javax.validation.constraints.NotNull;
import java.util.List;


/**
 * 业务参数Eo
 *
 * @author 黑马
 * @since 1.0.0
 */
@ApiModel(value = "SysParamRespDto", description = "业务参数Dto")
public class SysParamRespDto extends BaseRespDto {
    private static final long serialVersionUID = -7399978105737760313L;

    /**
     * 编码
     */
    @ApiModelProperty(value = "编码")
    @NotNull(message = "编码不能为空")
    private String code;

    /**
     * 名称
     */
    @ApiModelProperty(value = "名称")
    private String name;

    /**
     * 描述
     */
    @ApiModelProperty(value = "描述")
    private String description;

    /**
     * 级别(0:全局;1:租户;2:应用)
     */
    @ApiModelProperty(value = "级别(0:全局;1:租户;2:应用)")
    private Integer grade;

    /**
     * 选择类型(0:输入;1:单选;2:多选)
     */
    @ApiModelProperty(value = "选择类型(0:输入;1:单选;2:多选)")
    private Integer selectType;

    /**
     * 默认值
     */
    @ApiModelProperty(value = "默认值")
    private String defaultValue;

    /**
     * 值类型(0:文本;1:数值;2:布尔;3:日期)
     */
    @ApiModelProperty(value = "值类型(0:文本;1:数值;2:布尔;3:日期)")
    private Integer valueType;

    /**
     * 所属分组
     */
    @ApiModelProperty(value = "所属分组")
    private String groupCode;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;

    /**
     * 参数选项列表
     */
    @ApiModelProperty(value = "参数选项列表")
    private List<SysParamItemRespDto> sysParamItemList = new ArrayList<>();

    /**
     * 参数选项值列表
     */
    @ApiModelProperty(value = "参数选项值列表")
    private List<SysParamValueRespDto> sysParamValueList = new ArrayList<>();

    @ApiModelProperty(value = "关联的能力信息")
    private List<AbilityRespDto> abilityRespDtos;

    public List<AbilityRespDto> getAbilityRespDtos() {
        return abilityRespDtos;
    }

    public void setAbilityRespDtos(List<AbilityRespDto> abilityRespDtos) {
        this.abilityRespDtos = abilityRespDtos;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getGrade() {
        return grade;
    }

    public void setGrade(Integer grade) {
        this.grade = grade;
    }

    public Integer getSelectType() {
        return selectType;
    }

    public void setSelectType(Integer selectType) {
        this.selectType = selectType;
    }

    public String getDefaultValue() {
        return defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Integer getValueType() {
        return valueType;
    }

    public void setValueType(Integer valueType) {
        this.valueType = valueType;
    }

    public String getGroupCode() {
        return groupCode;
    }

    public void setGroupCode(String groupCode) {
        this.groupCode = groupCode;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public List<SysParamItemRespDto> getSysParamItemList() {
        return sysParamItemList;
    }

    public void setSysParamItemList(List<SysParamItemRespDto> sysParamItemList) {
        this.sysParamItemList = sysParamItemList;
    }

    public List<SysParamValueRespDto> getSysParamValueList() {
        return sysParamValueList;
    }

    public void setSysParamValueList(List<SysParamValueRespDto> sysParamValueList) {
        this.sysParamValueList = sysParamValueList;
    }
}
