/**
 * @(#)ViewBindCapabilityTreeDto 1.0 2020/3/20
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.dto.response;

import com.dtyunxi.yundt.cube.center.func.api.constants.Constants;
import com.dtyunxi.yundt.cube.center.func.api.dto.base.BaseRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.ITreeNode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * @author shuangqing  2020/3/20
 */
@ApiModel(value = "ViewSettingTreeDto", description = "创建配置视图关联能力树")
public class ViewSettingTreeDto extends BaseRespDto implements ITreeNode<ViewSettingTreeDto> {
    /**
     * 编码
     */
    @ApiModelProperty(value = "编码")
    private String code;

    /**
     * 名称
     */
    @ApiModelProperty(value = "类型：0 领域 1 能力 2 配置项 3 配置候选项")
    private Integer type;

    /**
     * 名称
     */
    @ApiModelProperty(value = "名称")
    private String name;

    /**
     * 排序号
     */
    @ApiModelProperty(value = "排序号")
    private Integer sort;

    /**
     * 是否已关联，1 表示该节点已被关联  0  表示该节点未被关联
     */
    @ApiModelProperty(value = "是否已关联，1 表示该节点已被当前视图关联  0  表示该节点未被当前视图关联")
    private Integer isSelected;

    /**
     * 是否不能被当前视图关联，是 1 否0
     */
    @ApiModelProperty(value = "是否不能被当前视图关联，是 1 否0 ")
    private Integer disabled;

    /**
     * 父编码
     */
    @ApiModelProperty(value = "父编码")
    private String parentCode;

    /**
     * 父类型
     */
    @ApiModelProperty(value = "父类型：0 领域 1 能力 2 配置项")
    private Integer parentType;

    /**
     * 备注、注释
     */
    @ApiModelProperty(value = "备注、注释")
    private String remark;

    /**
     * 子节点
     */
    @ApiModelProperty(value = "子节点")
    private List<ViewSettingTreeDto> children;

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Integer getDisabled() {
        return disabled;
    }

    public void setDisabled(Integer disabled) {
        this.disabled = disabled;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getSort() {
        return sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public Integer getIsSelected() {
        return isSelected;
    }

    public void setIsSelected(Integer isSelected) {
        this.isSelected = isSelected;
    }

    public String getParentCode() {
        return parentCode;
    }

    public void setParentCode(String parentCode) {
        this.parentCode = parentCode;
    }

    public Integer getParentType() {
        return parentType;
    }

    public void setParentType(Integer parentType) {
        this.parentType = parentType;
    }

    @Override
    public List<ViewSettingTreeDto> getChildren() {
        return children;
    }

    @Override
    public void setChildren(List<ViewSettingTreeDto> children) {
        this.children = children;
    }

    @Override
    public String getKey() {
        //这里的层级关系，除了配置项选项，其余的按照规范开发都不需要拼接type，原因是自定义的配置项选项与其他编码重复
        if (this.getType() != null && this.getType().equals(3)) {
            return this.getCode() + this.getType();
        }
        return this.getCode();
    }

    @Override
    public String getParentKey() {
        return this.getParentCode();
    }


    @Override
    public Boolean isRootNode() {
        return Constants.ROOT_NODE_PARENT_CODE.equals(this.getParentCode());
    }

    @Override
    public void addChild(ViewSettingTreeDto iTreeNode) {
        children.add(iTreeNode);
    }

}
