/*
 * @(#)CenterDataExceptionCode.java 1.0 2018/8/17
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.func.api.exception;

import com.dtyunxi.cube.enhance.generator.annotation.ExceptionEnum;

/**
 * @author 古奇
 * @since 1.0.0
 */
@ExceptionEnum
public enum FuncExceptionCode {
    //基础中心异常 4000<= code < 5000

    DATA_DUPLICATE_ERROR("4020", "数据重复"),
    BATCH_MORE_THAN_TWO_HUNDRED_ERROR("4021", "批量查询条件个数大于200"),
    PARAM_INVALID("4024", "参数异常"),
    CODE_IS_REPEATED_PARENT_CODE("4025", "编码和父级编码不能一样"),
    PARAM_NOT_EXISTS("4030", "找不到对应的参数"),
    RECORD_NOT_EXISTS("4033", "数据不存在"),
    RELATION_EXISTS("4034", "存在关联关系"),
    CONFIG_IMPORT_ALL_FAIL("4503", "提交失败，全部参数已存在或数据不符合要求"),
    CONFIG_IMPORT_PART_FAIL("4504", "提交失败，部分参数已存在或数据不符合要求"),
    BUNDLE_DELETE_FORBIDDEN("4505", "功能包被业务空间/能力引用或关联了配置项/配置项选项，不允许删除");


    private final String code;

    private final String msg;

    FuncExceptionCode(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public String getCode() {
        return code;
    }

    public String getMsg() {
        return msg;

    }
}
