package com.dtyunxi.yundt.cube.center.func.api.query;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.AbilityConfigReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.AbilityOverviewQueryDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.AbilityQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.ConfigOverviewReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.AbilityConfigDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.AbilityOverviewDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.AbilityQueryRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;
import java.util.List;

/**
 * 能力信息服务接口
 *
 * @author 代码生成器
 * @see com.dtyunxi.yundt.cube.center.func.api.query.ICapabilityQueryApi
 */
@Api(tags = {"基础数据中心：功能包能力地图：能力信息服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-data-api-query-IAbilityQueryApi",
        name = "${yundt.cube.center.data.api.name:yundt-cube-center-data}", path = "/v1/ability", url = "${yundt.cube.center.data.api:}")
@Deprecated
public interface IAbilityQueryApi {

    /**
     * 根据code查询能力信息
     *
     * @param code 能力信息code
     * @return 能力信息数据
     */
    @GetMapping("/{code}")
    @ApiOperation(value = "根据code查询能力信息", notes = "根据code查询能力信息")
    @Capability(capabilityCode = "basicdata.ability.query-by-code")
    RestResponse<AbilityQueryRespDto> queryByCode(@PathVariable("code") String code);

    /**
     * 能力信息分页数据
     *
     * @param abilityQueryReqDto 能力信息查询条件
     * @param pageNum            当前页
     * @param pageSize           页大小
     * @return 能力信息分页数据
     */
    @GetMapping("")
    @ApiOperation(value = "能力信息分页数据", notes = "能力信息分页数据")
    @Capability(capabilityCode = "basicdata.ability.query-by-page")
    RestResponse<PageInfo<AbilityQueryRespDto>> queryByPage(@SpringQueryMap AbilityQueryReqDto abilityQueryReqDto,
                                                            @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                            @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);


    /**
     * 查询能力地图
     *
     * @param abilityOverviewQueryDto 能力地图查询条件
     * @return 领域场景树
     */
    @GetMapping("/overview")
    @ApiOperation(value = "查询能力地图", notes = "查询能力地图")
    @Capability(capabilityCode = "basicdata.ability.query-ability-overview")
    RestResponse<AbilityOverviewDto> queryAbilityOverview(@SpringQueryMap AbilityOverviewQueryDto abilityOverviewQueryDto);

    /**
     * 根据业务空间code、场景code、能力code查询配置项
     * 返回数据层级太深，增加这个接口
     *
     * @param configOverviewReqDto
     * @return
     */
    @GetMapping("/overview/config")
    @ApiOperation(value = "根据业务空间code、场景code、能力code查询配置项", notes = "根据业务空间code、场景code、能力code查询配置项")
    @Capability(capabilityCode = "basicdata.ability.query-config")
    RestResponse<List<AbilityOverviewDto>> queryConfig(@Valid @SpringQueryMap ConfigOverviewReqDto configOverviewReqDto);

    /**
     * 根据能力code 查询关联的配置项信息
     *
     * @param abilityConfigReqDto 能力关联的配置项信息查询对象
     * @return 能力关联的配置项信息
     */
    @GetMapping("/config")
    @ApiOperation(value = "根据能力code 查询关联的配置项信息", notes = "根据能力code 查询关联的配置项信息")
    @Capability(capabilityCode = "basicdata.ability.query-ability-config")
    RestResponse<AbilityConfigDto> queryAbilityConfig(@Valid @SpringQueryMap AbilityConfigReqDto abilityConfigReqDto);

}
