package com.dtyunxi.yundt.cube.center.func.api.query;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.func.api.dto.TwoTuple;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.*;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.*;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * API服务
 */
@Api(tags = {"基础数据中心：功能包能力地图：API服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-data-api-query-IApiQueryApi",
        name = "${yundt.cube.center.data.api.name:yundt-cube-center-data}", path = "/v1/api", url = "${yundt.cube.center.data.api:}")
public interface IApiQueryApi {

    /**
     * 分页查询API
     *
     * @param apiQueryReqDto
     * @return
     */
    @GetMapping("/page")
    @ApiOperation(value = "分页查询API", notes = "分页查询API")
    @Capability(capabilityCode = "basicdata.api.query-by-page")
    RestResponse<PageInfo<ApiRespDto>> queryByPage(@SpringQueryMap ApiQueryReqDto apiQueryReqDto,
                                                   @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                   @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 查询API详情
     *
     * @param apiId
     * @return
     */
    @GetMapping("/{apiId}")
    @ApiOperation(value = "查询API详情", notes = "查询API详情")
    @Capability(capabilityCode = "basicdata.api.query-by-id")
    RestResponse<ApiDetailRespDto> queryById(@PathVariable("apiId") Long apiId);

    @Deprecated
    @GetMapping("/group")
    @ApiOperation(value = "查询所属中心名称，已废弃", notes = "查询所属中心名称")
    @Capability(capabilityCode = "basicdata.api.query-group-name")
    RestResponse<List<String>> queryGroupName();


    @GetMapping("/group/map")
    @ApiOperation(value = "查询所属中心码和名称映射集", notes = "查询所属中心码和名称映射集")
    @Capability(capabilityCode = "basicdata.api.query-group-name-map")
    RestResponse<Map<String, TwoTuple<String, Long>>> queryGroupNameMap();

    /**
     * 能力地图-根据领域编码查询API清单
     *
     * @param realmApiQueryReqDto
     * @return
     */
    @GetMapping("/realm/api")
    @ApiOperation(value = "能力地图-根据领域编码查询API清单", notes = "能力地图-根据领域编码查询API清单")
    @Capability(capabilityCode = "basicdata.api.query-realm-api")
    RestResponse<List<RealmApiRespDto>> queryRealmApi(@SpringQueryMap RealmApiQueryReqDto realmApiQueryReqDto);

    /**
     * 能力地图-根据领域编码查询错误码清单
     *
     * @param realmErrorCodeQueryReqDto
     * @return
     */
    @GetMapping("/realm/error-code")
    @ApiOperation(value = "能力地图-根据领域编码查询错误码清单", notes = "能力地图-根据领域编码查询错误码清单")
    @Capability(capabilityCode = "basicdata.api.query-realm-error-code")
    RestResponse<List<RealmErrorCodeRespDto>> queryRealmErrorCode(@SpringQueryMap RealmErrorCodeQueryReqDto realmErrorCodeQueryReqDto);


    /**
     * 统计中心数量
     *
     * @return
     */
    @GetMapping("/center/count")
    @ApiOperation(value = "统计中心数量", notes = "统计中心数量")
    @Capability(capabilityCode = "basicdata.api.count-centers")
    RestResponse<Integer> countCenters();

    /**
     * 批量根据api路径查询api基础信息
     *
     * @param apiBaseReqDto
     * @return
     */
    @PostMapping("/api/base-info/by-path/batch")
    @ApiOperation(value = "批量根据api路径查询api基础信息", notes = "批量根据api路径查询api基础信息")
    @Capability(capabilityCode = "basicdata.api.query-api-base-info-by-paths")
    RestResponse<List<ApiBaseRespDto>> queryApiBaseInfoByPaths(@RequestBody ApiBaseReqDto apiBaseReqDto);


    /**
     * 分页查询中心
     *
     * @param moduleDto
     * @return
     */
    @GetMapping("/module")
    @ApiOperation(value = "分页查询中心", notes = "分页查询中心")
    @Capability(capabilityCode = "basicdata.api.query-module-by-page")
    RestResponse<PageInfo<ModuleDto>> queryModuleByPage(@SpringQueryMap ModuleDto moduleDto,
                                                        @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                        @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);


    /**
     * api路径下拉框列表
     *
     * @param apiComboBoxReqDto API下拉框查询对象
     * @return
     */
    @GetMapping("/api/combo-box/list")
    @ApiOperation(value = "api路径下拉框列表", notes = "api路径下拉框列表")
    @Capability(capabilityCode = "basicdata.api.combo-box-list")
    RestResponse<List<ApiComboBoxRespDto>> comboBoxList(@SpringQueryMap ApiComboBoxReqDto apiComboBoxReqDto);

    /**
     * 查询功能包API清单分页数据
     *
     * @param queryReqDto 查询条件
     * @param pageNum     当前页
     * @param pageSize    页大小
     * @return 功能包API清单分页数据
     */
    @GetMapping("")
    @ApiOperation(value = "查询功能包API清单分页数据", notes = "查询功能包API清单分页数据")
    @Capability(capabilityCode = "basicdata.api.query-by-page")
    RestResponse<PageInfo<BundleApiQueryRespDto>> queryByPage(@SpringQueryMap BundleApiQueryReqDto queryReqDto,
                                                              @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                              @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 查询API详情
     *
     * @param moduleCode
     * @return
     */
    @GetMapping("/module-code")
    @ApiOperation(value = "查询中心下的API列表", notes = "查询中心下的API列表")
    @Capability(capabilityCode = "basicdata.api.query-by-module-code")
    RestResponse<List<ApiDto>> queryByModuleCode(@RequestParam(name = "moduleCode") String moduleCode);

    /**
     *
     * @param appCode 应用 code
     * @param appVersion 应用版本
     * @return
     */
    @GetMapping("/app-code-version")
    @ApiOperation(value = "查询中心下的API列表", notes = "查询中心下的API列表")
    RestResponse<List<ApiDto>> queryByAppCodeAndVersion(@RequestParam(name = "appCode") String appCode,
                                                        @RequestParam(name = "appVersion") String appVersion);
}
