package com.dtyunxi.yundt.cube.center.func.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.AppInstApiReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.GetMapping;
import com.github.pagehelper.PageInfo;

/**
* 应用模板和API关联关系表服务接口
*
* @author 代码生成器
*/
@Api(tags = {"应用模板和API关联关系表服务"})
@FeignClient(name = "${yundt.cube.center.data.api.name:yundt-cube-center-data}", path = "/v1/rappinstapi", url = "${yundt.cube.center.data.api:}")
public interface IAppInstApiQueryApi {

    /**
    * 根据id查询应用模板和API关联关系表
    *
    * @param id 应用模板和API关联关系表id
    * @return   应用模板和API关联关系表数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询应用模板和API关联关系表", notes = "根据id查询应用模板和API关联关系表")
    RestResponse<AppInstApiReqDto> queryById(@PathVariable("id") Long id);

    /**
    * 应用模板和API关联关系表分页数据
    *
    * @param reqDto   应用模板和API关联关系表查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 应用模板和API关联关系表分页数据
    */
    @GetMapping("")
    @ApiOperation(value = "应用模板和API关联关系表分页数据", notes = "根据RAppInstApiReqDto查询条件查询应用模板和API关联关系表数据")
    RestResponse<PageInfo<AppInstApiReqDto>> queryByPage(@SpringQueryMap AppInstApiReqDto reqDto,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
