package com.dtyunxi.yundt.cube.center.func.api.query;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * 通用服务接口
 *
 * @author : 萧玄
 * @GENERIC P 主键类型
 * @GENERIC DETAIL 对象详情返回类型
 * @GENERIC QUERY_REQ 分页查询参数类型
 * @GENERIC PAGE_RESP 分页返回对象类型
 * @Date : 14:50 2019/6/19
 */
public interface ICommonQueryApi<P, DETAIL, QUERY_REQ, PAGE_RESP> {


    @GetMapping("/{id}")
    @ResponseBody
    @ApiOperation(value = "详情", notes = "详情")
    @Capability(capabilityCode = "basicdata.common.get-detail")
    RestResponse<DETAIL> getDetail(@PathVariable("id") P id);

    @GetMapping("/page")
    @ResponseBody
    @ApiOperation(value = "分页列表", notes = "分页列表")
    @Capability(capabilityCode = "basicdata.common.query-page")
    RestResponse<PageInfo<PAGE_RESP>> queryPage(QUERY_REQ query);


}
