package com.dtyunxi.yundt.cube.center.func.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.DomainDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author shuangqing
 * @since 1.0.0
 */
@Api(tags = {"基础数据中心：领域服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-data-api-IDataMetaQueryApi",
        name = "${yundt.cube.center.data.api.name:yundt-cube-center-data}", path = "/v1/meta", url = "${yundt.cube.center.data.api:}")
public interface IDataMetaQueryApi {

    @GetMapping("/domain")
    @ApiOperation(value = "分页查询领域", notes = "分页查询领域")
    RestResponse<PageInfo<DomainDto>> queryDomainByPage(@SpringQueryMap DomainDto domainDto,
                                                        @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                        @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);
}
