package com.dtyunxi.yundt.cube.center.transform.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.SaleRefundReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.SaleRefundRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
* 销售退货单服务接口
*
* @author zimu
* @since 2022-05-19
*/
@Api(tags = {"销售退货单服务"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-cube-center-transform-api-ISaleRefundApi",
    name = "${yundt.cube.center.transform.api.name:yundt-cube-center-transform}",
    path = "/v1/pcp/order/refund/",
    url = "${yundt.cube.center.transform.api:}"
)
public interface IPcpSaleRefundApi {

    /**
    * （提供第三方）新增销售退货单
    *
    * @param addReqDto 销售退货单请求对象
    * @return 处理结果
    */
    @PostMapping("/addSaleRefund")
    @ApiOperation(value = "（提供第三方）新增销售退货单", notes = "新增销售退货单")
    RestResponse<Long> addSaleRefund(@RequestBody SaleRefundReqDto addReqDto);

    /**
    * （提供第三方）新增销售退货单
    *
    * @param addReqDto 销售退货单请求对象
    * @return 处理结果
    */
    @PostMapping("/cancel")
    @ApiOperation(value = "（提供第三方）取消销售退货单", notes = "取消销售退货单")
    RestResponse<Boolean> cancelSaleRefund(@RequestBody SaleRefundReqDto addReqDto);

}
