/**
 * @(#) PlatformOrderType.java 1.0 2022/3/10/010
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.transform.api.constant;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 平台订单状态枚举
 *
 * @author zimu
 * @date 2022/3/10/010
 * @since 1.0.0
 */
public enum PlatformOrderSource {

    // 订单来源 订单来源 0-手工创建 1-CSP推送 2-员工购 3-营养家 4-拆单 5-导入
    SOURCE_0(0, "手工创建"),
    SOURCE_1(1, "CSP推送"),
    SOURCE_2(2, "员工购"),
    SOURCE_3(3, "营养家"),
    SOURCE_4(5, "拆单"),
    SOURCE_6(6, "导入"),
    ;

    PlatformOrderSource(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public final int code;
    public final String desc;
    public static final Map<Integer, PlatformOrderSource> CODE_LOOKUP = Arrays.stream(values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum));
    public static final Map<Integer, String> CODE_DESC_MAP = Arrays.stream(values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum.desc));

    public static PlatformOrderSource forCode(int code) {
        return CODE_LOOKUP.get(code);
    }

    public Map<Integer, String> getCodeAndDesc() {
        return CODE_DESC_MAP;
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
