/**
 * @(#) ThirdOrderReqDto.java 1.0 2022/3/30/030
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.transform.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 描述
 *
 * @author zimu
 * @date 2022/3/30/030
 * @since 1.0.0
 */
@Data
@ApiModel(value = "ThirdOrderReqDto", description = "外部平台订单请求")
public class ThirdOrderReqDto extends BaseVo {
    /**
     * 平台订单号
     */
    @ApiModelProperty(name = "platformOrderNo", required = true, value = "平台订单号")
    private String platformOrderNo;
    /**
     * 平台父订单号
     */
    @ApiModelProperty(name = "platformParentOrderNo", value = "平台父订单号")
    private String platformParentOrderNo;
    /**
     * 平台下单时间
     */
    @ApiModelProperty(name = "platformCreateTime", required = true, value = "平台下单时间")
    private Date platformCreateTime;
    /**
     * 订单类型 0-大B订单 1-积分订单 2-普通订单
     */
    @ApiModelProperty(name = "orderType", required = true, value = "订单类型 0-大B订单 1-积分订单 2-普通订单")
    private Integer orderType;
    /**
     * 订单渠道code
     */
    @ApiModelProperty(name = "orderChannelCode", required = true, value = "订单渠道code")
    private String orderChannelCode;
    /**
     * 订单来源：0：线下 1: 线上
     */
    @ApiModelProperty(name = "isOnline", value = "订单来源：0：线下 1: 线上")
    private Integer isOnline;
    /**
     * 是否允许拆单标识：0-否 1-是
     */
    @ApiModelProperty(name = "canSplitFlag", required = true, value = "是否允许拆单标识：0-否 1-是")
    private Integer canSplitFlag;
    /**
     * 经销渠道
     */
    @ApiModelProperty(name = "saleChannel", value = "经销渠道")
    private String saleChannel;
    /**
     * 三方客户关联id（租户id）
     */
    @ApiModelProperty(name = "thirdPartyId", required = true, value = "三方客户关联id（租户id）")
    private String thirdPartyId;
    /**
     * 商品总金额
     */
    @ApiModelProperty(name = "goodsTotalAmount", required = true, value = "商品总金额")
    private BigDecimal goodsTotalAmount;
    /**
     * 应付金额
     */
    @ApiModelProperty(name = "orderTotalAmount", required = true, value = "应付金额")
    private BigDecimal orderTotalAmount;
    /**
     * 实付金额
     */
    @ApiModelProperty(name = "payAmount", value = "实付金额")
    private BigDecimal payAmount;
    /**
     * 支付时间
     */
    @ApiModelProperty(name = "payTime", value = "支付时间")
    private Date payTime;
    /**
     * 支付方式，alipay-支付宝-,wechat-微信,cash-现金,other-银联,union_pay-其他,sign_pay-标记支付
     */
    @ApiModelProperty(name = "payWay", value = "支付方式，alipay-支付宝-,wechat-微信,cash-现金,other-银联,union_pay-其他,sign_pay-标记支付")
    private String payWay;
    /**
     * 支付状态（0-未支付、1-已支付）
     */
    @ApiModelProperty(name = "payStatus", required = true, value = "支付状态（0-未支付、1-已支付）")
    private Integer payStatus;
    /**
     * 订单备注
     */
    @ApiModelProperty(name = "remark", value = "订单备注 ")
    private String remark;
    /**
     * 商家备注
     */
    @ApiModelProperty(name = "sellerRemark", value = "商家备注")
    private String sellerRemark;
    /**
     * 外部创建人
     */
    @ApiModelProperty(name = "outCreatePerson", value = "外部创建人")
    private String outCreatePerson;

    /**
     * 默认发货仓编码
     */
    @ApiModelProperty(name = "defaultWarehouseCode",required = true, value = "默认发货仓编码")
    private String defaultWarehouseCode;

    /**
     * 订单商品集合
     */
    @ApiModelProperty(name = "itemList", required = true, value = "订单商品集合")
    private List<PlatformOrderItemReqDto> itemReqDtoList;

    /**
     * 订单商品集合
     */
    @ApiModelProperty(name = "platformOrderAddrReqDto", required = true, value = "订单收货地址")
    private PlatformOrderAddrReqDto platformOrderAddrReqDto;

}
