/**
 * @(#) PlatformOrderCancelReqDto.java 1.0 2022/5/18/018
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.transform.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.yundt.cube.center.transform.api.constant.PlatformOrderStatusEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 平台订单取消请求
 *
 * @author zimu
 * @date 2022/5/18/018
 * @since 1.0.0
 */
@Data
@ApiModel(value = "PlatformOrderReqDto", description = "平台订单取消请求")
public class PlatformOrderCancelReqDto extends RequestDto {

    /**
     *  平台订单号
     */
    @ApiModelProperty(name = "platformOrderNo", value = "平台订单号")
    private String platformOrderNo;

    /**
     *  是否释放预占库存：0否，1是
     */
    @ApiModelProperty(name = "releaseState", value = "是否释放预占库存：0否，1是")
    private Integer releaseState;


    /**
     * @see PlatformOrderStatusEnum
     */
    @ApiModelProperty(name = "platformOrderStatus", value = "平台订单状态： submit:提交订单;audit_pass:审核成功;audit_not_pass:审核不通过;cancel:取消订单;")
    private String platformOrderStatus;

    @ApiModelProperty(name = "sourceOrderNo", value = "来源单号,经销订单传平台单号和积分单号，英文逗号隔开")
    private String sourceOrderNo;

    /**
     *  是否取消积分订单：0否，1是
     */
    @ApiModelProperty(name = "ifCancelIntegral", value = "是否取消积分订单：0否，1是 默认0；销售订单审核不通过使用")
    private Integer ifCancelIntegral = 0;

    @ApiModelProperty(name = "approvalRemark", value = "csp审批备注信息")
    private String approvalRemark;
    @ApiModelProperty(name = "approver", value = "csp审批人")
    private String approver;
}
