package com.dtyunxi.yundt.cube.center.transform.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.SaleRefundReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.SaleRefundRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.GetMapping;
import com.github.pagehelper.PageInfo;

/**
* 销售退货单服务接口
*
* @author zimu
* @since 2022-05-19
*/
@Api(tags = {"销售退货单服务"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-cube-center-transform-api-query-ISaleRefundQueryApi",
    name = "${yundt.cube.center.transform.api.name:yundt-cube-center-transform}",
    path = "/v1/pcp/order/refund/",
    url = "${yundt.cube.center.transform.api:}"
)
public interface IPcpSaleRefundQueryApi {

    /**
    * 根据id查询销售退货单
    *
    * @param id 销售退货单id
    * @return   销售退货单数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询销售退货单", notes = "根据id查询销售退货单")
    RestResponse<SaleRefundRespDto> queryById(@PathVariable("id") Long id);

}
