package com.dtyunxi.yundt.cube.center.transform.api.dto.response;

import java.util.Date;
import com.dtyunxi.dto.ResponseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import com.dtyunxi.dto.BaseRespDto;

/**
* 销售退货单Eo对象
*
* @author zimu
* @since 2022-05-19
*/
@ApiModel(value = "SaleRefundRespDto", description = "销售退货单Eo对象")
public class SaleRefundRespDto extends BaseRespDto{
    /**
    *  主键
    */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;
    /**
    *  组织id
    */
    @ApiModelProperty(name = "organizationId", value = "组织id")
    private Long organizationId;
    /**
    *  组织code
    */
    @ApiModelProperty(name = "organizationCode", value = "组织code")
    private String organizationCode;
    /**
    *  组织code
    */
    @ApiModelProperty(name = "organizationName", value = "组织code")
    private String organizationName;
    /**
    *  平台退货单号
    */
    @ApiModelProperty(name = "platformRefundNo", value = "平台退货单号")
    private String platformRefundNo;
    /**
    *  销售退货单号
    */
    @ApiModelProperty(name = "saleRefundNo", value = "销售退货单号")
    private String saleRefundNo;
    /**
    *  平台退货申请时间
    */
    @ApiModelProperty(name = "platformRefundApplyTime", value = "平台退货申请时间")
    private Date platformRefundApplyTime;
    /**
    *  销售退货单类型 NORMAL:常规退货、SPECIAL:特殊退货、BACK:回购退货
    */
    @ApiModelProperty(name = "refundType", value = "销售退货单类型 NORMAL:常规退货、SPECIAL:特殊退货、BACK:回购退货")
    private String refundType;
    /**
    *  内部销售退货单号（暂时没用）
    */
    @ApiModelProperty(name = "refundNo", value = "内部销售退货单号（暂时没用）")
    private String refundNo;
    /**
    *  销售退货状态 WAIT_CHECK:待确认、WAIT_HANDLE:待处理、PART_OUTBOUND：部分入库、COMPLETE：已完成、CANCEL：已取消、CANCELING：取消中
    */
    @ApiModelProperty(name = "refundStatus", value = "销售退货状态 WAIT_CHECK:待确认、WAIT_HANDLE:待处理、PART_OUTBOUND：部分入库、COMPLETE：已完成、CANCEL：已取消、CANCELING：取消中")
    private String refundStatus;
    /**
    *  实际退货时间
    */
    @ApiModelProperty(name = "actualRefundTime", value = "实际退货时间")
    private Date actualRefundTime;
    /**
    *  第三方客户租户id
    */
    @ApiModelProperty(name = "thirdPartyId", value = "第三方客户租户id")
    private String thirdPartyId;
    /**
    *  联系人名称
    */
    @ApiModelProperty(name = "contactPersonName", value = "联系人名称")
    private String contactPersonName;
    /**
    *  联系电话
    */
    @ApiModelProperty(name = "contactPhone", value = "联系电话")
    private String contactPhone;
    /**
    *  销售组织名称
    */
    @ApiModelProperty(name = "saleOrgName", value = "销售组织名称")
    private String saleOrgName;
    /**
    *  订单渠道id
    */
    @ApiModelProperty(name = "orderChannelId", value = "订单渠道id")
    private Long orderChannelId;
    /**
    *  订单渠道code
    */
    @ApiModelProperty(name = "orderChannelCode", value = "订单渠道code")
    private String orderChannelCode;
    /**
    *  订单渠道名称
    */
    @ApiModelProperty(name = "orderChannelName", value = "订单渠道名称")
    private String orderChannelName;
    /**
    *  客户编码
    */
    @ApiModelProperty(name = "customerCode", value = "客户编码")
    private String customerCode;
    /**
    *  客户名称
    */
    @ApiModelProperty(name = "customerName", value = "客户名称")
    private String customerName;
    /**
    *  客户id
    */
    @ApiModelProperty(name = "customerId", value = "客户id")
    private Long customerId;
    /**
    *  商品总数量
    */
    @ApiModelProperty(name = "goodsTotalNum", value = "商品总数量")
    private BigDecimal goodsTotalNum;
    /**
    *  商品sku总数量
    */
    @ApiModelProperty(name = "goodsSkuTotalNum", value = "商品sku总数量")
    private BigDecimal goodsSkuTotalNum;
    /**
    *  申请销售退货仓编码
    */
    @ApiModelProperty(name = "applyRefundWarehouseCode", value = "申请销售退货仓编码")
    private String applyRefundWarehouseCode;
    /**
    *  申请销售退货仓名称
    */
    @ApiModelProperty(name = "applyRefundWarehouseName", value = "申请销售退货仓名称")
    private String applyRefundWarehouseName;
    /**
    *  退货金额
    */
    @ApiModelProperty(name = "refundTotalAmount", value = "退货金额")
    private BigDecimal refundTotalAmount;
    /**
    *  业务单创建日期
    */
    @ApiModelProperty(name = "platformRefundCreateTime", value = "业务单创建日期")
    private Date platformRefundCreateTime;
    /**
    *  所用流程
    */
    @ApiModelProperty(name = "flowDefId", value = "所用流程")
    private Long flowDefId;

    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }
    public void setOrganizationId(Long organizationId){
    this.organizationId = organizationId;
    }
    public Long getOrganizationId(){
    return this.organizationId;
    }
    public void setOrganizationCode(String organizationCode){
    this.organizationCode = organizationCode;
    }
    public String getOrganizationCode(){
    return this.organizationCode;
    }
    public void setOrganizationName(String organizationName){
    this.organizationName = organizationName;
    }
    public String getOrganizationName(){
    return this.organizationName;
    }
    public void setPlatformRefundNo(String platformRefundNo){
    this.platformRefundNo = platformRefundNo;
    }
    public String getPlatformRefundNo(){
    return this.platformRefundNo;
    }
    public void setSaleRefundNo(String saleRefundNo){
    this.saleRefundNo = saleRefundNo;
    }
    public String getSaleRefundNo(){
    return this.saleRefundNo;
    }
    public void setPlatformRefundApplyTime(Date platformRefundApplyTime){
    this.platformRefundApplyTime = platformRefundApplyTime;
    }
    public Date getPlatformRefundApplyTime(){
    return this.platformRefundApplyTime;
    }
    public void setRefundType(String refundType){
    this.refundType = refundType;
    }
    public String getRefundType(){
    return this.refundType;
    }
    public void setRefundNo(String refundNo){
    this.refundNo = refundNo;
    }
    public String getRefundNo(){
    return this.refundNo;
    }
    public void setRefundStatus(String refundStatus){
    this.refundStatus = refundStatus;
    }
    public String getRefundStatus(){
    return this.refundStatus;
    }
    public void setActualRefundTime(Date actualRefundTime){
    this.actualRefundTime = actualRefundTime;
    }
    public Date getActualRefundTime(){
    return this.actualRefundTime;
    }
    public void setThirdPartyId(String thirdPartyId){
    this.thirdPartyId = thirdPartyId;
    }
    public String getThirdPartyId(){
    return this.thirdPartyId;
    }
    public void setContactPersonName(String contactPersonName){
    this.contactPersonName = contactPersonName;
    }
    public String getContactPersonName(){
    return this.contactPersonName;
    }
    public void setContactPhone(String contactPhone){
    this.contactPhone = contactPhone;
    }
    public String getContactPhone(){
    return this.contactPhone;
    }
    public void setSaleOrgName(String saleOrgName){
    this.saleOrgName = saleOrgName;
    }
    public String getSaleOrgName(){
    return this.saleOrgName;
    }
    public void setOrderChannelId(Long orderChannelId){
    this.orderChannelId = orderChannelId;
    }
    public Long getOrderChannelId(){
    return this.orderChannelId;
    }
    public void setOrderChannelCode(String orderChannelCode){
    this.orderChannelCode = orderChannelCode;
    }
    public String getOrderChannelCode(){
    return this.orderChannelCode;
    }
    public void setOrderChannelName(String orderChannelName){
    this.orderChannelName = orderChannelName;
    }
    public String getOrderChannelName(){
    return this.orderChannelName;
    }
    public void setCustomerCode(String customerCode){
    this.customerCode = customerCode;
    }
    public String getCustomerCode(){
    return this.customerCode;
    }
    public void setCustomerName(String customerName){
    this.customerName = customerName;
    }
    public String getCustomerName(){
    return this.customerName;
    }
    public void setCustomerId(Long customerId){
    this.customerId = customerId;
    }
    public Long getCustomerId(){
    return this.customerId;
    }
    public void setGoodsTotalNum(BigDecimal goodsTotalNum){
    this.goodsTotalNum = goodsTotalNum;
    }
    public BigDecimal getGoodsTotalNum(){
    return this.goodsTotalNum;
    }
    public void setGoodsSkuTotalNum(BigDecimal goodsSkuTotalNum){
    this.goodsSkuTotalNum = goodsSkuTotalNum;
    }
    public BigDecimal getGoodsSkuTotalNum(){
    return this.goodsSkuTotalNum;
    }
    public void setApplyRefundWarehouseCode(String applyRefundWarehouseCode){
    this.applyRefundWarehouseCode = applyRefundWarehouseCode;
    }
    public String getApplyRefundWarehouseCode(){
    return this.applyRefundWarehouseCode;
    }
    public void setApplyRefundWarehouseName(String applyRefundWarehouseName){
    this.applyRefundWarehouseName = applyRefundWarehouseName;
    }
    public String getApplyRefundWarehouseName(){
    return this.applyRefundWarehouseName;
    }
    public void setRefundTotalAmount(BigDecimal refundTotalAmount){
    this.refundTotalAmount = refundTotalAmount;
    }
    public BigDecimal getRefundTotalAmount(){
    return this.refundTotalAmount;
    }
    public void setPlatformRefundCreateTime(Date platformRefundCreateTime){
    this.platformRefundCreateTime = platformRefundCreateTime;
    }
    public Date getPlatformRefundCreateTime(){
    return this.platformRefundCreateTime;
    }
    public void setFlowDefId(Long flowDefId){
    this.flowDefId = flowDefId;
    }
    public Long getFlowDefId(){
    return this.flowDefId;
    }
}
