package com.dtyunxi.yundt.cube.center.transform.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderQueryReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.PlatformOrderRespDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.ThirdSaleOrderDetailRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
* 平台订单表服务接口
*
* @author zimu
* @since 2022-03-08
*/
@Api(tags = {"平台订单表服务"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-cube-center-transform-api-query-IPlatformOrderQueryApi",
    name = "${yundt.cube.center.transform.api.name:yundt-cube-center-transform}",
    path = "/v1/platform/order",
    url = "${yundt.cube.center.transform.api:}"
)
public interface IPlatformOrderQueryApi {

    /**
    * 根据id查询平台订单表
    *
    * @param id 平台订单表id
    * @return   平台订单表数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询平台订单表", notes = "根据id查询平台订单表")
    RestResponse<PlatformOrderRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 根据平台订单号查询平台订单表
    *
    * @param platformNo 平台订单号
    * @return   平台订单表数据
    */
    @GetMapping("/platform/{platformNo}")
    @ApiOperation(value = "根据平台订单号查询平台订单表", notes = "根据平台订单号查询平台订单表")
    RestResponse<PlatformOrderRespDto> queryByPlatformNo(@PathVariable("platformNo") String platformNo);

    /**
     * 根据内部销售订单号查询平台订单表
     *
     * @param saleNo 平台订单号
     * @return   平台订单表数据
     */
    @GetMapping("/sale/{saleNo}")
    @ApiOperation(value = "根据内部销售订单号查询平台订单表", notes = "根据内部销售订单号查询平台订单表")
    RestResponse<PlatformOrderRespDto> queryBySaleNo(@PathVariable("saleNo") String saleNo);


    @GetMapping({"/third/detail/query/{platformNo}"})
    @ApiOperation(value = "（提供第三方查询）根据平台订单号查询销售订单详情", notes = "（提供第三方查询）根据平台订单号查询销售订单详情")
    RestResponse<ThirdSaleOrderDetailRespDto> queryOrderDetailByPlatformNo(@PathVariable("platformNo") String platformNo);

    /**
    * 平台订单表分页数据
    *
    * @param filter   平台订单表查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 平台订单表分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "平台订单表分页数据", notes = "根据filter查询条件查询平台订单表数据，filter=PlatformOrderReqDto")
    RestResponse<PageInfo<PlatformOrderRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    @PostMapping("/queryListByParam")
    @ApiOperation(value = "根据参数查询平台订单表", notes = "根据参数查询平台订单表")
    RestResponse<List<PlatformOrderRespDto>> queryListByParam(@RequestBody PlatformOrderQueryReqDto reqDto);

}
