/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.wechat.org.biz.mq.event;

import cn.hutool.core.util.ObjectUtil;
import com.dtyunxi.cube.domain.event.service.IDomainEventListener;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.channel.api.enums.ChannelAccountTypeEnum;
import com.dtyunxi.yundt.cube.center.channel.event.ChannelAccountEventDto;
import com.dtyunxi.yundt.cube.center.wechat.org.api.dto.request.SyncDepartmentDto;
import com.dtyunxi.yundt.cube.center.wechat.org.biz.service.IWeChatDepartmentService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ChannelAccountEventProcessor
implements IDomainEventListener<ChannelAccountEventDto> {
    private static Logger logger = LoggerFactory.getLogger(ChannelAccountEventProcessor.class);
    @Resource
    private IWeChatDepartmentService departmentService;

    public MessageResponse process(ChannelAccountEventDto dto) {
        if (ObjectUtil.equal((Object)ChannelAccountTypeEnum.WECHAT_ENTERPRISE_ACCOUNT.getKey(), (Object)dto.getType())) {
            logger.info("\u63a5\u6536\u5230\u6e20\u9053\u8d26\u53f7\u53d8\u66f4\u9886\u57df\u4e8b\u4ef6");
            switch (dto.getOpType()) {
                case "ADD": 
                case "UPDATE": {
                    SyncDepartmentDto syncDepartmentDto = new SyncDepartmentDto();
                    syncDepartmentDto.setChannelAccount(dto.getAccount());
                    syncDepartmentDto.setTenantId(dto.getTenantId());
                    this.departmentService.syncDepartmentToBoc(syncDepartmentDto);
                }
            }
        }
        return MessageResponse.SUCCESS;
    }
}

