/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.wechat.org.biz.mq.event;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.domain.event.service.IDomainEventListener;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.user.event.EmployeeEventDto;
import com.dtyunxi.yundt.cube.center.wechat.org.biz.service.IWeChatEmployeeService;
import com.dtyunxi.yundt.cube.center.wechat.org.biz.util.EmployeeUtil;
import com.dtyunxi.yundt.cube.center.wechat.org.biz.vo.EmployeeVo;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EmployeeEventProcessor
implements IDomainEventListener<EmployeeEventDto> {
    private static Logger logger = LoggerFactory.getLogger(EmployeeEventProcessor.class);
    @Resource
    private IWeChatEmployeeService employeeService;

    public MessageResponse process(EmployeeEventDto dto) {
        switch (dto.getOpType()) {
            case "ADD": {
                EmployeeVo employeeVo = new EmployeeVo();
                employeeVo.setEmployeeId(dto.getId());
                employeeVo.setEmployeeNo(dto.getEmployeeNo());
                employeeVo.setUserid(dto.getEmployeeNo());
                employeeVo.setName(dto.getName());
                employeeVo.setMobile(dto.getPhoneNum());
                employeeVo.setEmail(dto.getEmail());
                employeeVo.setEnable(EmployeeUtil.getEnable(dto.getStatus()));
                employeeVo.setOrgIds(dto.getOrgIds());
                employeeVo.setPostNames(dto.getPostNames());
                this.employeeService.createEmployee(employeeVo);
                break;
            }
            case "UPDATE": {
                EmployeeVo updateVo = new EmployeeVo();
                updateVo.setEmployeeId(dto.getId());
                updateVo.setEmployeeNo(dto.getEmployeeNo());
                updateVo.setUserid(dto.getEmployeeNo());
                updateVo.setName(dto.getName());
                updateVo.setMobile(dto.getPhoneNum());
                updateVo.setEmail(dto.getEmail());
                updateVo.setEnable(EmployeeUtil.getEnable(dto.getStatus()));
                updateVo.setOrgIds(dto.getOrgIds());
                updateVo.setPostNames(dto.getPostNames());
                this.employeeService.updateEmployee(updateVo);
                break;
            }
            case "DELETE": {
                List employeeIds = dto.getEmployIds();
                logger.info("\u6279\u91cf\u5220\u9664\u5458\u5de5\uff0c\u5458\u5de5id\u4e3a[{}]", (Object)JSONObject.toJSONString((Object)employeeIds));
                if (!CollectionUtil.isNotEmpty((Collection)employeeIds)) break;
                this.employeeService.batchDeleteEmployee(employeeIds);
                break;
            }
            case "POST_UPDATE": {
                List ids = dto.getEmployIds();
                logger.info("\u6279\u91cf\u66f4\u65b0\u5458\u5de5\u5c97\u4f4d\uff0c\u5458\u5de5id\u4e3a[{}]", (Object)JSONObject.toJSONString((Object)ids));
                if (!CollectionUtil.isNotEmpty((Collection)ids)) break;
                this.employeeService.batchUpdateEmployeePost(ids);
                break;
            }
            case "STATUS_UPDATE": {
                logger.info("\u6279\u91cf\u66f4\u65b0\u5458\u5de5\u72b6\u6001\uff0c\u5458\u5de5id\u4e3a[{}]", (Object)JSONObject.toJSONString((Object)dto.getEmployIds()));
                if (!CollectionUtil.isNotEmpty((Collection)dto.getEmployIds())) break;
                this.employeeService.batchUpdateEmployeeStatus(dto.getEmployIds(), dto.getStatus());
            }
        }
        return MessageResponse.SUCCESS;
    }
}

