/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.wechat.org.biz.mq.event;

import com.dtyunxi.cube.domain.event.service.IDomainEventListener;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.user.biz.service.IOrganizationExtService;
import com.dtyunxi.yundt.cube.center.user.event.OrganizationEventDto;
import com.dtyunxi.yundt.cube.center.wechat.org.biz.service.IWeChatDepartmentService;
import com.dtyunxi.yundt.cube.center.wechat.org.biz.vo.DepartmentCreateVo;
import com.dtyunxi.yundt.cube.center.wechat.org.biz.vo.DepartmentDeleteVo;
import com.dtyunxi.yundt.cube.center.wechat.org.biz.vo.DepartmentUpdateVo;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class OrganizationEventProcessor
implements IDomainEventListener<OrganizationEventDto> {
    private static Logger logger = LoggerFactory.getLogger(OrganizationEventProcessor.class);
    @Resource
    private IWeChatDepartmentService departmentService;
    @Resource
    private IOrganizationExtService organizationExtService;

    public MessageResponse process(OrganizationEventDto dto) {
        if ("ADD".equals(dto.getOpType()) && !this.organizationExtService.isHumanResourceOrg(dto.getId()).booleanValue()) {
            return MessageResponse.SUCCESS;
        }
        switch (dto.getOpType()) {
            case "ADD": {
                DepartmentCreateVo createVo = new DepartmentCreateVo();
                createVo.setBocOrgId(dto.getId());
                createVo.setName(StringUtils.isNotBlank((CharSequence)dto.getName()) ? dto.getName() : dto.getCode());
                createVo.setName_en(dto.getNameI1());
                Long bocOrgParentId = this.organizationExtService.getHumanResourceParentOrgId(dto.getId());
                logger.info("\u8bbe\u7f6e\u4eba\u529b\u7ec4\u7ec7\u7236\u8282\u70b9id\u4e3a{}", (Object)bocOrgParentId);
                createVo.setBocOrgParentId(bocOrgParentId);
                createVo.setOrder(dto.getSortNO() == null ? null : Long.valueOf(dto.getSortNO().intValue()));
                this.departmentService.createDepartment(createVo);
                break;
            }
            case "UPDATE": {
                DepartmentUpdateVo updateVo = new DepartmentUpdateVo();
                updateVo.setBocOrgId(dto.getId());
                updateVo.setName(StringUtils.isNotBlank((CharSequence)dto.getName()) ? dto.getName() : dto.getCode());
                updateVo.setName_en(dto.getNameI1());
                updateVo.setOrder(dto.getSortNO() == null ? null : Long.valueOf(dto.getSortNO().intValue()));
                this.departmentService.updateDepartment(updateVo);
                break;
            }
            case "DELETE": {
                DepartmentDeleteVo deleteVo = new DepartmentDeleteVo();
                deleteVo.setBocOrgId(dto.getId());
                this.departmentService.deleteDepartment(deleteVo);
            }
        }
        return MessageResponse.SUCCESS;
    }
}

