/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.wechat.org.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeAddReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgOrgDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgThirdReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.vo.WeChatConfigVo;
import com.dtyunxi.yundt.cube.center.user.api.enums.ThirdTypeEnum;
import com.dtyunxi.yundt.cube.center.user.biz.service.IEmployeeExtService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IEmployeeThirdService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IOrgThirdService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IOrganizationExtService;
import com.dtyunxi.yundt.cube.center.user.biz.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.biz.vo.SyncEmployeeVo;
import com.dtyunxi.yundt.cube.center.user.biz.vo.SyncOrgAndEmployeeReqVo;
import com.dtyunxi.yundt.cube.center.user.biz.vo.SyncOrgAndEmployeeVo;
import com.dtyunxi.yundt.cube.center.user.biz.vo.SyncOrgVo;
import com.dtyunxi.yundt.cube.center.user.dao.das.AppInstanceDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.EmployeeOrgDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.EmployeeThirdDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.OrgThirdDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.OrganizationDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.AppInstanceEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.EmployeeOrgEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.EmployeeThirdEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.OrgThirdEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.OrganizationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdEmployeeEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdEmployeeOrgEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdEmployeeThirdEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdOrgThirdEo;
import com.dtyunxi.yundt.cube.center.user.dao.mapper.EmployeeMapper;
import com.dtyunxi.yundt.cube.center.user.dao.mapper.OrganizationMapper;
import com.dtyunxi.yundt.cube.center.wechat.org.api.dto.request.OrgAndEmployeeReqDto;
import com.dtyunxi.yundt.cube.center.wechat.org.api.dto.request.SyncDepartmentDto;
import com.dtyunxi.yundt.cube.center.wechat.org.api.dto.response.OrgAndEmployeeRespDto;
import com.dtyunxi.yundt.cube.center.wechat.org.api.dto.response.WeChatEmployeeRespDto;
import com.dtyunxi.yundt.cube.center.wechat.org.api.dto.response.WeChatOrgRespDto;
import com.dtyunxi.yundt.cube.center.wechat.org.biz.service.IWeChatDepartmentService;
import com.dtyunxi.yundt.cube.center.wechat.org.biz.service.IWeChatEmployeeService;
import com.dtyunxi.yundt.cube.center.wechat.org.biz.service.IWeChatService;
import com.dtyunxi.yundt.cube.center.wechat.org.biz.util.DepartmentUtil;
import com.dtyunxi.yundt.cube.center.wechat.org.biz.util.EmployeeUtil;
import com.dtyunxi.yundt.cube.center.wechat.org.biz.vo.AgentInfoVo;
import com.dtyunxi.yundt.cube.center.wechat.org.biz.vo.DepartmentBaseVo;
import com.dtyunxi.yundt.cube.center.wechat.org.biz.vo.DepartmentCreateVo;
import com.dtyunxi.yundt.cube.center.wechat.org.biz.vo.DepartmentDeleteVo;
import com.dtyunxi.yundt.cube.center.wechat.org.biz.vo.DepartmentUpdateVo;
import com.dtyunxi.yundt.cube.center.wechat.org.biz.vo.EmployeeBaseVo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WeChatDepartmentServiceImpl
implements IWeChatDepartmentService {
    private static Logger logger = LoggerFactory.getLogger(WeChatDepartmentServiceImpl.class);
    private static final Long WX_ROOT_ID = 1L;
    private static final Long BOC_ROOT_PARENT_ID = -1L;
    @Resource
    private IWeChatService weChatService;
    @Resource
    private IOrgThirdService orgThirdService;
    @Resource
    private OrganizationDas organizationDas;
    @Resource
    private OrgThirdDas orgThirdDas;
    @Resource
    private EmployeeThirdDas employeeThirdDas;
    @Resource
    private IOrganizationExtService organizationExtService;
    @Resource
    private IEmployeeThirdService employeeThirdService;
    @Resource
    private IWeChatEmployeeService weChatEmployeeService;
    @Resource
    private IEmployeeExtService employeeService;
    @Resource
    private AppInstanceDas appInstanceDas;
    @Resource
    private OrganizationMapper organizationMapper;
    @Resource
    private EmployeeMapper employeeMapper;
    @Resource
    private EmployeeOrgDas employeeOrgDas;

    @Override
    public void createDepartment(DepartmentCreateVo createVo) {
        String accessToken = this.weChatService.getAccessToken(JSONObject.toJSONString((Object)createVo));
        if (accessToken == null) {
            return;
        }
        Long parentId = this.getParentId(createVo.getBocOrgParentId(), JSONObject.toJSONString((Object)createVo));
        if (parentId == null) {
            return;
        }
        createVo.setParentid(parentId);
        String thirdOrgId = DepartmentUtil.createDepartment(accessToken, createVo);
        if (thirdOrgId != null) {
            OrgThirdReqDto addOrgThirdReqDto = new OrgThirdReqDto();
            addOrgThirdReqDto.setOrgId(createVo.getBocOrgId());
            addOrgThirdReqDto.setThirdOrgId(thirdOrgId);
            addOrgThirdReqDto.setType(ThirdTypeEnum.ENTERPRISE_WECHAT.getType());
            this.orgThirdService.addOrgThird(addOrgThirdReqDto);
        }
    }

    private Long getParentId(Long bocOrgParentId, String paramJson) {
        Long parentId = null;
        if (bocOrgParentId == null || bocOrgParentId == 0L || bocOrgParentId == -1L) {
            parentId = WX_ROOT_ID;
        } else {
            OrgThirdReqDto orgThirdReqDto = this.getOrgThirdReqDto(bocOrgParentId, paramJson);
            if (orgThirdReqDto != null) {
                parentId = Long.valueOf(orgThirdReqDto.getThirdOrgId());
            }
        }
        return parentId;
    }

    private OrgThirdReqDto getOrgThirdReqDto(Long id, String paramJson) {
        OrgThirdReqDto orgThirdReqDto = this.orgThirdService.queryById(id, ThirdTypeEnum.ENTERPRISE_WECHAT.getType());
        if (orgThirdReqDto == null) {
            logger.error("\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7id-\u4f01\u4e1a\u5fae\u4fe1\u90e8\u95e8id\u7ed1\u5b9a\u5173\u7cfb\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)paramJson);
            return null;
        }
        return orgThirdReqDto;
    }

    @Override
    public void updateDepartment(DepartmentUpdateVo updateVo) {
        OrgThirdReqDto orgThirdReqDto = this.getOrgThirdReqDto(updateVo.getBocOrgId(), JSONObject.toJSONString((Object)updateVo));
        if (orgThirdReqDto == null) {
            if (this.organizationExtService.isHumanResourceOrg(updateVo.getBocOrgId()).booleanValue()) {
                DepartmentCreateVo createVo = new DepartmentCreateVo();
                CubeBeanUtils.copyProperties((Object)createVo, (Object)updateVo, (String[])new String[0]);
                Long bocOrgParentId = this.organizationExtService.getHumanResourceParentOrgId(updateVo.getBocOrgId());
                logger.info("\u8bbe\u7f6e\u4eba\u529b\u7ec4\u7ec7\u7236\u8282\u70b9id\u4e3a{}", (Object)bocOrgParentId);
                createVo.setBocOrgParentId(bocOrgParentId);
                this.createDepartment(createVo);
            }
        } else {
            String accessToken = this.weChatService.getAccessToken(JSONObject.toJSONString((Object)updateVo));
            if (accessToken == null) {
                return;
            }
            if (this.organizationExtService.isHumanResourceOrg(updateVo.getBocOrgId()).booleanValue()) {
                Long bocOrgParentId = this.organizationExtService.getHumanResourceParentOrgId(updateVo.getBocOrgId());
                logger.info("\u8bbe\u7f6e\u4eba\u529b\u7ec4\u7ec7\u7236\u8282\u70b9id\u4e3a{}", (Object)bocOrgParentId);
                updateVo.setBocOrgParentId(bocOrgParentId);
                Long parentId = this.getParentId(updateVo.getBocOrgParentId(), JSONObject.toJSONString((Object)updateVo));
                if (parentId == null) {
                    return;
                }
                updateVo.setParentid(parentId);
                updateVo.setId(Long.valueOf(orgThirdReqDto.getThirdOrgId()));
                DepartmentUtil.updateDepartment(accessToken, updateVo);
            } else {
                boolean result = DepartmentUtil.deleteDepartment(accessToken, Long.valueOf(orgThirdReqDto.getThirdOrgId()));
                if (result) {
                    this.orgThirdService.removeOrgThird(updateVo.getBocOrgId(), ThirdTypeEnum.ENTERPRISE_WECHAT.getType());
                }
            }
        }
    }

    @Override
    public void deleteDepartment(DepartmentDeleteVo deleteVo) {
        String accessToken = this.weChatService.getAccessToken(JSONObject.toJSONString((Object)deleteVo));
        if (accessToken == null) {
            return;
        }
        OrgThirdReqDto orgThirdReqDto = this.getOrgThirdReqDto(deleteVo.getBocOrgId(), JSONObject.toJSONString((Object)deleteVo));
        if (orgThirdReqDto == null) {
            return;
        }
        this.deleteDepartment(accessToken, Long.valueOf(orgThirdReqDto.getThirdOrgId()), orgThirdReqDto.getOrgId());
    }

    @Override
    public Long syncDepartment(SyncDepartmentDto syncDepartmentDto) {
        Long tenantId = syncDepartmentDto.getTenantId() == null ? ServiceContext.getContext().getRequestTenantId() : syncDepartmentDto.getTenantId();
        SyncOrgAndEmployeeReqVo reqVo = new SyncOrgAndEmployeeReqVo();
        reqVo.setTenantId(tenantId);
        SyncOrgAndEmployeeVo syncVo = this.organizationExtService.getOrgAndEmployeeVo(reqVo);
        if (syncVo == null || CollectionUtil.isEmpty((Collection)syncVo.getOrgVoList())) {
            throw new BizException("500", "\u672a\u83b7\u53d6\u5230BOC\u7ec4\u7ec7\u4fe1\u606f");
        }
        String accessToken = this.weChatService.getAccessToken("");
        if (accessToken == null) {
            throw new BizException("500", "\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1AccessToken\u5931\u8d25");
        }
        HashMap<Long, String> addBocOrgId2ThirdOrgIdMap = new HashMap<Long, String>();
        HashMap<Long, String> updateBocOrgId2ThirdOrgIdMap = new HashMap<Long, String>();
        Map<Long, OrgThirdEo> dbOrgId2ThirdOrgIdMap = new HashMap<Long, OrgThirdEo>();
        List dbOgThirdEoList = this.orgThirdService.queryByIdList(syncVo.getOrgIdList(), ThirdTypeEnum.ENTERPRISE_WECHAT.getType());
        if (CollectionUtil.isNotEmpty((Collection)dbOgThirdEoList)) {
            dbOrgId2ThirdOrgIdMap = dbOgThirdEoList.parallelStream().collect(Collectors.toMap(StdOrgThirdEo::getOrgId, a -> a));
        }
        this.createDepartment(dbOrgId2ThirdOrgIdMap, syncVo.getOrgVoList(), WX_ROOT_ID, addBocOrgId2ThirdOrgIdMap, updateBocOrgId2ThirdOrgIdMap, accessToken);
        addBocOrgId2ThirdOrgIdMap.putAll(updateBocOrgId2ThirdOrgIdMap);
        this.handleEmployeeVoList(syncVo, accessToken, addBocOrgId2ThirdOrgIdMap);
        List deleteOrgThirdEoList = this.orgThirdService.queryNotInIdList(syncVo.getOrgIdList(), ThirdTypeEnum.ENTERPRISE_WECHAT.getType());
        if (CollectionUtil.isNotEmpty((Collection)deleteOrgThirdEoList)) {
            deleteOrgThirdEoList.forEach(orgThirdEo -> this.deleteDepartment(accessToken, Long.valueOf(orgThirdEo.getThirdOrgId()), orgThirdEo.getOrgId()));
        }
        return syncVo.getOrgIdList().size();
    }

    private void deleteDepartment(String accessToken, Long departmentId, Long orgId) {
        boolean result;
        Long id;
        boolean batchDeleteEmployeeResult;
        if (departmentId == null) {
            return;
        }
        String department = DepartmentUtil.listDepartment(accessToken, departmentId);
        if (department == null) {
            logger.info("\u672a\u67e5\u8be2\u5230\u4f01\u4e1a\u5fae\u4fe1\u90e8\u95e8\u4fe1\u606f\uff0c\u90e8\u95e8id:{}", (Object)departmentId);
            return;
        }
        List list = JSONObject.parseArray((String)department, DepartmentBaseVo.class);
        if (CollectionUtil.isEmpty((Collection)list)) {
            logger.info("\u672a\u67e5\u8be2\u5230\u4f01\u4e1a\u5fae\u4fe1\u90e8\u95e8\u4fe1\u606f\uff0c\u90e8\u95e8id:{}", (Object)departmentId);
            return;
        }
        Map<Long, List<DepartmentBaseVo>> parentId2DepartmentBaseVoListMap = list.parallelStream().collect(Collectors.groupingBy(DepartmentBaseVo::getParentid));
        List<Long> idList = this.getDepartmentIdList(null, departmentId, parentId2DepartmentBaseVoListMap);
        CollectionUtil.reverse(idList);
        Iterator<Long> iterator = idList.iterator();
        while (iterator.hasNext() && (batchDeleteEmployeeResult = this.weChatEmployeeService.batchUpdateOrDeleteEmployee(id = iterator.next())) && (result = DepartmentUtil.deleteDepartment(accessToken, id))) {
            this.orgThirdService.removeOrgThird(orgId, ThirdTypeEnum.ENTERPRISE_WECHAT.getType());
        }
    }

    private List<Long> getDepartmentIdList(List<Long> idList, Long parentId, Map<Long, List<DepartmentBaseVo>> childrenMap) {
        List<DepartmentBaseVo> children;
        if (idList == null) {
            idList = new ArrayList<Long>();
            idList.add(parentId);
        }
        if (CollectionUtils.isNotEmpty(children = childrenMap.get(parentId))) {
            ArrayList<Long> sameLevelIdList = new ArrayList<Long>();
            for (DepartmentBaseVo vo : children) {
                sameLevelIdList.add(vo.getId());
                idList.add(vo.getId());
            }
            for (Long id : sameLevelIdList) {
                this.getDepartmentIdList(idList, id, childrenMap);
            }
        }
        return idList;
    }

    private void handleEmployeeVoList(SyncOrgAndEmployeeVo syncVo, String accessToken, Map<Long, String> bocOrgId2ThirdOrgIdMap) {
        List<String> deleteUserIds;
        boolean result;
        if (CollectionUtil.isEmpty((Collection)syncVo.getEmployeeVoList())) {
            logger.info("\u5458\u5de5\u4fe1\u606f\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u540c\u6b65");
            return;
        }
        HashMap<Long, String> employeeId2ThirdEmployeeIdMap = new HashMap<Long, String>();
        List employeeIds = syncVo.getEmployeeVoList().parallelStream().map(SyncEmployeeVo::getId).collect(Collectors.toList());
        List employeeThirdEoList = this.employeeThirdService.queryByIdList(employeeIds, ThirdTypeEnum.ENTERPRISE_WECHAT.getType());
        Map<Long, EmployeeThirdEo> employeeId2EmployeeThirdEoMap = employeeThirdEoList.parallelStream().collect(Collectors.toMap(StdEmployeeThirdEo::getEmployeeId, a -> a));
        syncVo.getEmployeeVoList().forEach(syncEmployeeVo -> {
            EmployeeThirdEo employeeThirdEo;
            EmployeeBaseVo employeeBaseVo = new EmployeeBaseVo();
            employeeBaseVo.setUserid(syncEmployeeVo.getEmployeeNo());
            employeeBaseVo.setName(syncEmployeeVo.getName());
            employeeBaseVo.setMobile(syncEmployeeVo.getPhoneNum());
            employeeBaseVo.setEmail(syncEmployeeVo.getEmail());
            if (CollectionUtil.isEmpty((Collection)syncEmployeeVo.getOrgIds())) {
                logger.info("\u5458\u5de5\u6240\u5c5e\u7ec4\u7ec7id\u5217\u8868\u4e3a\u7a7a\u6216\u4e0d\u5728\u4efb\u4e00\u4eba\u529b\u7ec4\u7ec7\u4e0b\uff0c\u4e0d\u8fdb\u884c\u5458\u5de5\u6570\u636e\u540c\u6b65\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)syncEmployeeVo));
                return;
            }
            ArrayList<Long> department = new ArrayList<Long>(syncEmployeeVo.getOrgIds().size());
            syncEmployeeVo.getOrgIds().forEach(orgId -> {
                String thirdOrgId = (String)bocOrgId2ThirdOrgIdMap.get(orgId);
                if (thirdOrgId != null) {
                    department.add(Long.valueOf(thirdOrgId));
                }
            });
            if (CollectionUtil.isEmpty(department)) {
                logger.info("\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7id-\u4f01\u4e1a\u5fae\u4fe1\u90e8\u95e8id\u7ed1\u5b9a\u5173\u7cfb\uff0c\u4e0d\u8fdb\u884c\u5458\u5de5\u6570\u636e\u540c\u6b65\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)syncEmployeeVo.getOrgIds()));
                return;
            }
            employeeBaseVo.setDepartment(department);
            if (CollectionUtil.isNotEmpty((Collection)syncEmployeeVo.getPostNames())) {
                employeeBaseVo.setPosition(StringUtils.join((Iterable)syncEmployeeVo.getPostNames(), (String)","));
            }
            if ((employeeThirdEo = (EmployeeThirdEo)employeeId2EmployeeThirdEoMap.get(syncEmployeeVo.getId())) == null) {
                boolean result = EmployeeUtil.createEmployee(accessToken, employeeBaseVo);
                if (result) {
                    employeeId2ThirdEmployeeIdMap.put(syncEmployeeVo.getId(), syncEmployeeVo.getEmployeeNo());
                }
            } else {
                EmployeeUtil.updateEmployee(accessToken, employeeBaseVo);
            }
        });
        ArrayList addEmployeeThirdEoList = new ArrayList(employeeId2ThirdEmployeeIdMap.size());
        employeeId2ThirdEmployeeIdMap.forEach((key, value) -> {
            EmployeeThirdEo employeeThirdEo = new EmployeeThirdEo();
            employeeThirdEo.setEmployeeId(key);
            employeeThirdEo.setThirdEmployeeId(value);
            employeeThirdEo.setType(ThirdTypeEnum.ENTERPRISE_WECHAT.getType());
            employeeThirdEo.setExtension("");
            addEmployeeThirdEoList.add(employeeThirdEo);
        });
        this.employeeThirdDas.insertBatch(addEmployeeThirdEoList);
        List deleteEmployeeThirdEoList = this.employeeThirdService.queryNotInIdList(employeeIds, ThirdTypeEnum.ENTERPRISE_WECHAT.getType());
        if (CollectionUtil.isNotEmpty((Collection)deleteEmployeeThirdEoList) && (result = EmployeeUtil.batchDeleteEmployee(accessToken, deleteUserIds = deleteEmployeeThirdEoList.stream().map(StdEmployeeThirdEo::getThirdEmployeeId).collect(Collectors.toList())))) {
            List deleteEmployeeIds = deleteEmployeeThirdEoList.parallelStream().map(StdEmployeeThirdEo::getEmployeeId).collect(Collectors.toList());
            this.employeeThirdService.deleteByIdList(deleteEmployeeIds, ThirdTypeEnum.ENTERPRISE_WECHAT.getType());
        }
    }

    private void createDepartment(Map<Long, OrgThirdEo> dbOrgId2ThirdOrgIdMap, List<SyncOrgVo> syncOrgVoList, Long wxParentId, Map<Long, String> addBocOrgId2ThirdOrgIdMap, Map<Long, String> updateBocOrgId2ThirdOrgIdMap, String accessToken) {
        if (CollectionUtil.isNotEmpty(syncOrgVoList)) {
            syncOrgVoList.forEach(syncOrgVo -> {
                String thirdOrgId;
                OrgThirdEo orgThirdEo = (OrgThirdEo)dbOrgId2ThirdOrgIdMap.get(syncOrgVo.getId());
                if (orgThirdEo == null) {
                    DepartmentCreateVo createVo = new DepartmentCreateVo();
                    createVo.setName(StringUtils.isNotBlank((CharSequence)syncOrgVo.getName()) ? syncOrgVo.getName() : syncOrgVo.getCode());
                    createVo.setName_en(syncOrgVo.getCode());
                    createVo.setParentid(wxParentId);
                    createVo.setOrder(syncOrgVo.getSortNO() == null ? null : Long.valueOf(syncOrgVo.getSortNO().intValue()));
                    thirdOrgId = DepartmentUtil.createDepartment(accessToken, createVo);
                    if (thirdOrgId == null) {
                        throw new BizException("500", "\u521b\u5efa\u4f01\u4e1a\u5fae\u4fe1\u90e8\u95e8\u5931\u8d25");
                    }
                    OrgThirdReqDto addOrgThirdReqDto = new OrgThirdReqDto();
                    addOrgThirdReqDto.setOrgId(syncOrgVo.getId());
                    addOrgThirdReqDto.setThirdOrgId(thirdOrgId);
                    addOrgThirdReqDto.setType(ThirdTypeEnum.ENTERPRISE_WECHAT.getType());
                    this.orgThirdService.addOrgThird(addOrgThirdReqDto);
                    addBocOrgId2ThirdOrgIdMap.put(syncOrgVo.getId(), thirdOrgId);
                } else {
                    thirdOrgId = orgThirdEo.getThirdOrgId();
                    DepartmentUpdateVo updateVo = new DepartmentUpdateVo();
                    updateVo.setName(StringUtils.isNotBlank((CharSequence)syncOrgVo.getName()) ? syncOrgVo.getName() : syncOrgVo.getCode());
                    updateVo.setName_en(syncOrgVo.getCode());
                    updateVo.setParentid(wxParentId);
                    updateVo.setId(Long.valueOf(thirdOrgId));
                    updateVo.setOrder(syncOrgVo.getSortNO() == null ? null : Long.valueOf(syncOrgVo.getSortNO().intValue()));
                    DepartmentUtil.updateDepartment(accessToken, updateVo);
                    updateBocOrgId2ThirdOrgIdMap.put(syncOrgVo.getId(), thirdOrgId);
                }
                this.createDepartment(dbOrgId2ThirdOrgIdMap, syncOrgVo.getChildren(), Long.valueOf(thirdOrgId), addBocOrgId2ThirdOrgIdMap, updateBocOrgId2ThirdOrgIdMap, accessToken);
            });
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long syncDepartmentToBoc(SyncDepartmentDto syncDepartmentDto) {
        List employeeList;
        String accessToken = this.weChatService.getDepartmentAccessToken(syncDepartmentDto.getChannelAccount());
        if (accessToken == null) {
            throw new BizException("500", "\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1AccessToken\u5931\u8d25");
        }
        Long tenantId = syncDepartmentDto.getTenantId() == null ? ServiceContext.getContext().getRequestTenantId() : syncDepartmentDto.getTenantId();
        String departmentJson = DepartmentUtil.listDepartment(accessToken, null);
        if (departmentJson == null) {
            throw new BizException("500", "\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1\u90e8\u95e8\u5217\u8868\u5931\u8d25");
        }
        List departmentList = JSONObject.parseArray((String)departmentJson, DepartmentBaseVo.class);
        if (CollectionUtil.isEmpty((Collection)departmentList)) {
            throw new BizException("500", "\u4f01\u4e1a\u5fae\u4fe1\u90e8\u95e8\u5217\u8868\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u540c\u6b65");
        }
        String employeeJson = EmployeeUtil.listEmployee(accessToken, WX_ROOT_ID, 1);
        if (employeeJson == null) {
            logger.info("\u672a\u67e5\u8be2\u5230\u4f01\u4e1a\u5fae\u4fe1\u5458\u5de5\u4fe1\u606f\uff0c\u90e8\u95e8id:{}", (Object)WX_ROOT_ID);
        }
        if (CollectionUtil.isEmpty((Collection)(employeeList = JSONObject.parseArray((String)employeeJson, EmployeeBaseVo.class)))) {
            logger.info("\u672a\u67e5\u8be2\u5230\u4f01\u4e1a\u5fae\u4fe1\u5458\u5de5\u4fe1\u606f\uff0c\u90e8\u95e8id:{}", (Object)WX_ROOT_ID);
        }
        ArrayList departmentTree = Lists.newArrayList();
        Map<Long, List<DepartmentBaseVo>> childrenMap = departmentList.stream().collect(Collectors.groupingBy(DepartmentBaseVo::getParentid));
        departmentList.forEach(department -> {
            if (department.getId().equals(WX_ROOT_ID)) {
                this.buildDepartmentTree((DepartmentBaseVo)department, childrenMap);
                departmentTree.add(department);
            }
        });
        HashMap<String, Long> dbDepartmentId2bocOrgIdMap = new HashMap();
        HashMap<Long, Long> departmentId2bocOrgIdMap = new HashMap<Long, Long>();
        ArrayList<OrganizationEo> organizationEoList = new ArrayList<OrganizationEo>();
        OrgThirdEo queryOrgThirdEo = new OrgThirdEo();
        queryOrgThirdEo.setTenantId(tenantId);
        List dbOrgThirdEoList = this.orgThirdDas.selectList((BaseEo)queryOrgThirdEo);
        if (CollectionUtil.isNotEmpty((Collection)dbOrgThirdEoList)) {
            dbDepartmentId2bocOrgIdMap = dbOrgThirdEoList.parallelStream().collect(Collectors.toMap(StdOrgThirdEo::getThirdOrgId, StdOrgThirdEo::getOrgId));
            throw new BizException("500", "\u4f01\u4e1a\u5fae\u4fe1\u90e8\u95e8\u53ca\u5458\u5de5\u6570\u636e\u5df2\u540c\u6b65\u8fc7\uff0c\u4e0d\u518d\u8fdb\u884c\u540c\u6b65");
        }
        Long bocOrgParentId = BOC_ROOT_PARENT_ID;
        List rootOrganizationEoList = this.organizationDas.findRootByTenantId(tenantId);
        if (CollectionUtil.isNotEmpty((Collection)rootOrganizationEoList)) {
            bocOrgParentId = ((OrganizationEo)rootOrganizationEoList.get(0)).getId();
        }
        this.createOrg(departmentTree, bocOrgParentId, dbDepartmentId2bocOrgIdMap, departmentId2bocOrgIdMap, organizationEoList);
        this.organizationExtService.addBatchOrg(organizationEoList);
        OrgThirdEo deleteEo = new OrgThirdEo();
        deleteEo.setTenantId(tenantId);
        this.orgThirdDas.delete((BaseEo)deleteEo);
        ArrayList orgThirdEoList = new ArrayList(departmentId2bocOrgIdMap.size());
        departmentId2bocOrgIdMap.forEach((key, value) -> {
            OrgThirdEo orgThirdEo = new OrgThirdEo();
            orgThirdEo.setOrgId(value);
            orgThirdEo.setThirdOrgId(key.toString());
            orgThirdEo.setType(ThirdTypeEnum.ENTERPRISE_WECHAT.getType());
            orgThirdEo.setExtension("");
            orgThirdEo.setTenantId(tenantId);
            orgThirdEoList.add(orgThirdEo);
        });
        this.orgThirdDas.insertBatch(orgThirdEoList);
        HashMap<String, Long> userId2bocEmployeeIdMap = new HashMap<String, Long>();
        ArrayList<EmployeeAddReqDto> employeeAddReqDtoList = new ArrayList<EmployeeAddReqDto>();
        this.createEmployee(employeeList, departmentId2bocOrgIdMap, userId2bocEmployeeIdMap, employeeAddReqDtoList);
        if (CollectionUtil.isNotEmpty(employeeAddReqDtoList)) {
            this.employeeService.addBatchEmployee(employeeAddReqDtoList);
        }
        if (MapUtil.isNotEmpty(userId2bocEmployeeIdMap)) {
            EmployeeThirdEo deleteEmployeeThirdEo = new EmployeeThirdEo();
            deleteEmployeeThirdEo.setTenantId(tenantId);
            this.employeeThirdDas.delete((BaseEo)deleteEmployeeThirdEo);
            ArrayList addEmployeeThirdEoList = new ArrayList(userId2bocEmployeeIdMap.size());
            userId2bocEmployeeIdMap.forEach((key, value) -> {
                EmployeeThirdEo employeeThirdEo = new EmployeeThirdEo();
                employeeThirdEo.setEmployeeId(value);
                employeeThirdEo.setThirdEmployeeId(key);
                employeeThirdEo.setType(ThirdTypeEnum.ENTERPRISE_WECHAT.getType());
                employeeThirdEo.setExtension("");
                employeeThirdEo.setTenantId(tenantId);
                addEmployeeThirdEoList.add(employeeThirdEo);
            });
            this.employeeThirdDas.insertBatch(addEmployeeThirdEoList);
        }
        return departmentList.size();
    }

    private void createEmployee(List<EmployeeBaseVo> employeeList, Map<Long, Long> departmentId2bocOrgIdMap, Map<String, Long> userId2bocEmployeeIdMap, List<EmployeeAddReqDto> employeeAddReqDtoList) {
        if (CollectionUtil.isNotEmpty(employeeList)) {
            employeeList.forEach(employee -> {
                List<Long> departmentIdList = employee.getDepartment();
                if (CollectionUtil.isEmpty(departmentIdList)) {
                    logger.info("\u5458\u5de5\u6240\u5c5e\u7ec4\u7ec7id\u5217\u8868\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u5458\u5de5\u6570\u636e\u540c\u6b65\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)employee));
                    return;
                }
                ArrayList orgIdList = new ArrayList(departmentIdList.size());
                departmentIdList.forEach(departmentId -> {
                    Long orgId = (Long)departmentId2bocOrgIdMap.get(departmentId);
                    if (orgId != null) {
                        orgIdList.add(orgId);
                    }
                });
                if (CollectionUtil.isEmpty(orgIdList)) {
                    logger.info("\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7id-\u4f01\u4e1a\u5fae\u4fe1\u90e8\u95e8id\u7ed1\u5b9a\u5173\u7cfb\uff0c\u4e0d\u8fdb\u884c\u5458\u5de5\u6570\u636e\u540c\u6b65\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString(departmentIdList));
                    return;
                }
                List orgDtoList = orgIdList.stream().map(orgId -> {
                    OrgOrgDto orgOrgDto = new OrgOrgDto();
                    orgOrgDto.setOrgId(orgId);
                    return orgOrgDto;
                }).collect(Collectors.toList());
                EmployeeAddReqDto addReqDto = new EmployeeAddReqDto();
                addReqDto.setEmployeeNo(employee.getUserid());
                addReqDto.setName(employee.getName());
                addReqDto.setPhoneNum(employee.getMobile());
                addReqDto.setEmail(employee.getEmail());
                addReqDto.setOrgDtoList(orgDtoList);
                Long employeeId = IdGenrator.getDistributedId();
                addReqDto.setId(employeeId);
                employeeAddReqDtoList.add(addReqDto);
                userId2bocEmployeeIdMap.put(employee.getUserid(), employeeId);
            });
        }
    }

    private void createOrg(List<DepartmentBaseVo> departmentTree, Long bocOrgParentId, Map<String, Long> dbDepartmentId2bocOrgIdMap, Map<Long, Long> departmentId2bocOrgIdMap, List<OrganizationEo> organizationEoList) {
        if (CollectionUtil.isNotEmpty(departmentTree)) {
            departmentTree.forEach(department -> {
                Long bocOrgId = (Long)dbDepartmentId2bocOrgIdMap.get(department.getId());
                OrganizationEo organizationEo = new OrganizationEo();
                organizationEo.setName(department.getName());
                organizationEo.setParentId(bocOrgParentId);
                Long id = IdGenrator.getDistributedId();
                organizationEo.setId(id);
                organizationEo.setCode(id.toString());
                organizationEoList.add(organizationEo);
                departmentId2bocOrgIdMap.put(department.getId(), id);
                this.createOrg(department.getChildren(), id, dbDepartmentId2bocOrgIdMap, departmentId2bocOrgIdMap, organizationEoList);
            });
        }
    }

    private void buildDepartmentTree(DepartmentBaseVo departmentBaseVo, Map<Long, List<DepartmentBaseVo>> childrenMap) {
        List<DepartmentBaseVo> children = childrenMap.get(departmentBaseVo.getId());
        if (CollectionUtils.isNotEmpty(children)) {
            departmentBaseVo.setChildren(children);
            for (DepartmentBaseVo vo : children) {
                this.buildDepartmentTree(vo, childrenMap);
            }
        }
    }

    @Override
    public OrgAndEmployeeRespDto queryOrgAndEmployee(OrgAndEmployeeReqDto orgAndEmployeeReqDto) {
        List<AgentInfoVo.User> users;
        List<String> partyIds;
        List orgThirdEoList;
        Long appInstanceId = orgAndEmployeeReqDto.getAppInstanceId();
        AssertUtil.isTrue((appInstanceId != null ? 1 : 0) != 0, (String)"\u5e94\u7528\u5b9e\u4f8bid\u4e0d\u80fd\u4e3a\u7a7a");
        AppInstanceEo appInstanceEo = (AppInstanceEo)this.appInstanceDas.selectByPrimaryKey(appInstanceId);
        if (appInstanceEo == null) {
            throw new BizException("500", "\u5e94\u7528\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        String instanceConfig = appInstanceEo.getInstanceConfig();
        if (StrUtil.isBlank((CharSequence)appInstanceEo.getAccount()) || StrUtil.isBlank((CharSequence)instanceConfig)) {
            throw new BizException("500", "\u5e94\u7528\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\u6216\u4e0d\u5b8c\u6574");
        }
        WeChatConfigVo weChatConfigVo = (WeChatConfigVo)JSON.parseObject((String)instanceConfig, WeChatConfigVo.class);
        String accessToken = this.weChatService.getAccessToken(appInstanceEo.getAccount(), weChatConfigVo.getAppSecret());
        if (StrUtil.isBlank((CharSequence)accessToken)) {
            return null;
        }
        String agentInfoJson = DepartmentUtil.getAgentInfo(accessToken, weChatConfigVo.getAppId());
        if (StrUtil.isBlank((CharSequence)agentInfoJson)) {
            return null;
        }
        AgentInfoVo agentInfoVo = (AgentInfoVo)JSON.parseObject((String)agentInfoJson, AgentInfoVo.class);
        AgentInfoVo.AllowParty allowParty = agentInfoVo.getAllowPartys();
        AgentInfoVo.AllowUserInfo allowUserInfo = agentInfoVo.getAllowUserInfos();
        OrgAndEmployeeRespDto orgAndEmployeeRespDto = new OrgAndEmployeeRespDto();
        if (allowParty != null && CollectionUtil.isNotEmpty((Collection)(orgThirdEoList = this.orgThirdService.queryByThirdIdList(partyIds = allowParty.getPartyId(), ThirdTypeEnum.ENTERPRISE_WECHAT.getType())))) {
            List orgIdList = orgThirdEoList.stream().map(StdOrgThirdEo::getOrgId).collect(Collectors.toList());
            List organizationEoList = this.organizationMapper.selectList((Wrapper)new QueryWrapper().lambda().in(BaseEo::getId, orgIdList));
            ArrayList weChatOrgRespDtoList = new ArrayList(organizationEoList.size());
            CubeBeanUtils.copyCollection(weChatOrgRespDtoList, (Collection)organizationEoList, WeChatOrgRespDto.class);
            orgAndEmployeeRespDto.setOrgAdvRespDtoList(weChatOrgRespDtoList);
        }
        if (allowUserInfo != null && CollectionUtil.isNotEmpty(users = allowUserInfo.getUser())) {
            List<String> userIds = users.stream().map(AgentInfoVo.User::getUserId).collect(Collectors.toList());
            List<WeChatEmployeeRespDto> employeeRespDtoList = this.getEmployeeRespDtoList(userIds, orgAndEmployeeReqDto);
            if (CollectionUtil.isNotEmpty(employeeRespDtoList)) {
                List employeeIdList = employeeRespDtoList.stream().map(WeChatEmployeeRespDto::getId).collect(Collectors.toList());
                List employeeOrgEoList = this.employeeOrgDas.findByEmployeeIds(employeeIdList);
                Map<Long, List<EmployeeOrgEo>> employeeId2EmployeeOrgMap = employeeOrgEoList.stream().collect(Collectors.groupingBy(StdEmployeeOrgEo::getEmployeeId));
                employeeRespDtoList.forEach(dto -> {
                    List eoList = (List)employeeId2EmployeeOrgMap.get(dto.getId());
                    if (CollectionUtil.isNotEmpty((Collection)eoList)) {
                        List orgIds = eoList.stream().map(StdEmployeeOrgEo::getOrganizationId).collect(Collectors.toList());
                        List organizationEo = this.organizationDas.selectByIds(orgIds);
                        List orgDtos = organizationEo.stream().map(e -> {
                            WeChatOrgRespDto orgOrgDto = new WeChatOrgRespDto();
                            orgOrgDto.setId(e.getId());
                            orgOrgDto.setName(e.getName());
                            return orgOrgDto;
                        }).collect(Collectors.toList());
                        dto.setOrgDtoList(orgDtos);
                    }
                });
            }
            orgAndEmployeeRespDto.setEmployeeRespDtoList(employeeRespDtoList);
        }
        return orgAndEmployeeRespDto;
    }

    @Override
    public List<WeChatEmployeeRespDto> getEmployeeRespDtoList(List<String> userIds, OrgAndEmployeeReqDto orgAndEmployeeReqDto) {
        if (CollectionUtil.isEmpty(userIds)) {
            return null;
        }
        ArrayList employeeRespDtoList = null;
        List employeeThirdEoList = this.employeeThirdService.queryByThirdIdList(userIds, ThirdTypeEnum.ENTERPRISE_WECHAT.getType());
        if (CollectionUtil.isNotEmpty((Collection)employeeThirdEoList)) {
            List employeeIdList = employeeThirdEoList.stream().map(StdEmployeeThirdEo::getEmployeeId).collect(Collectors.toList());
            List employeeEoList = this.employeeMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().in(BaseEo::getId, employeeIdList)).like(StrUtil.isNotBlank((CharSequence)orgAndEmployeeReqDto.getEmployeeName()), StdEmployeeEo::getName, (Object)orgAndEmployeeReqDto.getEmployeeName())).ge(orgAndEmployeeReqDto.getCreateTimeStart() != null, BaseEo::getCreateTime, (Object)orgAndEmployeeReqDto.getCreateTimeStart())).lt(orgAndEmployeeReqDto.getCreateTimeEnd() != null, BaseEo::getCreateTime, (Object)orgAndEmployeeReqDto.getCreateTimeEnd()));
            employeeRespDtoList = new ArrayList(employeeEoList.size());
            CubeBeanUtils.copyCollection(employeeRespDtoList, (Collection)employeeEoList, WeChatEmployeeRespDto.class);
        }
        return employeeRespDtoList;
    }
}

