/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.wechat.org.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeThirdReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.vo.WeChatConfigVo;
import com.dtyunxi.yundt.cube.center.user.api.enums.ThirdTypeEnum;
import com.dtyunxi.yundt.cube.center.user.biz.service.IEmployeeThirdService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IOrgThirdService;
import com.dtyunxi.yundt.cube.center.user.biz.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.dao.das.AppInstanceDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.EmployeePostDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.PostDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.AppInstanceEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.EmployeePostEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdEmployeePostEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdEmployeeThirdEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdPostEo;
import com.dtyunxi.yundt.cube.center.wechat.org.api.dto.request.ExternalContactReqDto;
import com.dtyunxi.yundt.cube.center.wechat.org.api.dto.request.FollowUserReqDto;
import com.dtyunxi.yundt.cube.center.wechat.org.api.dto.request.GroupChatDetailReqDto;
import com.dtyunxi.yundt.cube.center.wechat.org.api.dto.request.GroupChatReqDto;
import com.dtyunxi.yundt.cube.center.wechat.org.api.dto.request.OrgAndEmployeeReqDto;
import com.dtyunxi.yundt.cube.center.wechat.org.api.dto.response.WeChatEmployeeRespDto;
import com.dtyunxi.yundt.cube.center.wechat.org.biz.service.IWeChatDepartmentService;
import com.dtyunxi.yundt.cube.center.wechat.org.biz.service.IWeChatEmployeeService;
import com.dtyunxi.yundt.cube.center.wechat.org.biz.service.IWeChatService;
import com.dtyunxi.yundt.cube.center.wechat.org.biz.util.EmployeeUtil;
import com.dtyunxi.yundt.cube.center.wechat.org.biz.util.ExternalContactUtil;
import com.dtyunxi.yundt.cube.center.wechat.org.biz.vo.EmployeeBaseVo;
import com.dtyunxi.yundt.cube.center.wechat.org.biz.vo.EmployeeVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class WeChatEmployeeServiceImpl
implements IWeChatEmployeeService {
    private static Logger logger = LoggerFactory.getLogger(WeChatEmployeeServiceImpl.class);
    @Resource
    private IWeChatService weChatService;
    @Resource
    private IEmployeeThirdService employeeThirdService;
    @Resource
    private IOrgThirdService orgThirdService;
    @Resource
    private EmployeePostDas employeePostDas;
    @Resource
    private PostDas postDas;
    @Resource
    private IWeChatDepartmentService departmentService;
    @Resource
    private AppInstanceDas appInstanceDas;

    @Override
    public void createEmployee(EmployeeVo employeeVo) {
        EmployeeBaseVo employeeBaseVo = this.getEmployeeBaseVo(employeeVo);
        if (CollectionUtil.isEmpty(employeeBaseVo.getDepartment())) {
            logger.info("\u5458\u5de5\u6240\u5c5e\u7ec4\u7ec7id\u5217\u8868\u4e3a\u7a7a\u6216\u4e0d\u5728\u4efb\u4e00\u4eba\u529b\u7ec4\u7ec7\u4e0b\uff0c\u4e0d\u8fdb\u884c\u5458\u5de5\u6570\u636e\u540c\u6b65\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)employeeVo));
            return;
        }
        String accessToken = this.weChatService.getAccessToken(JSONObject.toJSONString((Object)employeeVo));
        if (accessToken == null) {
            return;
        }
        boolean result = EmployeeUtil.createEmployee(accessToken, employeeBaseVo);
        if (result) {
            EmployeeThirdReqDto dto = new EmployeeThirdReqDto();
            dto.setEmployeeId(employeeVo.getEmployeeId());
            dto.setThirdEmployeeId(employeeVo.getEmployeeNo());
            dto.setType(ThirdTypeEnum.ENTERPRISE_WECHAT.getType());
            this.employeeThirdService.addUserThird(dto);
        }
    }

    private EmployeeBaseVo getEmployeeBaseVo(EmployeeVo employeeVo) {
        EmployeeBaseVo employeeBaseVo = new EmployeeBaseVo();
        CubeBeanUtils.copyProperties((Object)employeeBaseVo, (Object)employeeVo, (String[])new String[0]);
        if (CollectionUtil.isNotEmpty(employeeVo.getOrgIds())) {
            List orgThirdEoList = this.orgThirdService.queryByIdList(employeeVo.getOrgIds(), ThirdTypeEnum.ENTERPRISE_WECHAT.getType());
            if (CollectionUtil.isNotEmpty((Collection)orgThirdEoList)) {
                List<Long> departmentList = orgThirdEoList.stream().map(eo -> Long.valueOf(eo.getThirdOrgId())).collect(Collectors.toList());
                employeeBaseVo.setDepartment(departmentList);
            } else {
                logger.info("\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7id-\u4f01\u4e1a\u5fae\u4fe1\u90e8\u95e8id\u7ed1\u5b9a\u5173\u7cfb\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString(employeeVo.getOrgIds()));
            }
        }
        if (CollectionUtil.isNotEmpty(employeeVo.getPostNames())) {
            employeeBaseVo.setPosition(StringUtils.join(employeeVo.getPostNames(), (String)","));
        }
        return employeeBaseVo;
    }

    @Override
    public void updateEmployee(EmployeeVo employeeVo) {
        EmployeeThirdReqDto employeeThirdReqDto = this.getEmployeeThirdReqDto(employeeVo.getEmployeeId(), JSONObject.toJSONString((Object)employeeVo));
        if (employeeThirdReqDto == null) {
            this.createEmployee(employeeVo);
        } else {
            String accessToken = this.weChatService.getAccessToken(JSONObject.toJSONString((Object)employeeVo));
            if (accessToken == null) {
                return;
            }
            EmployeeBaseVo employeeBaseVo = this.getEmployeeBaseVo(employeeVo);
            if (CollectionUtil.isEmpty(employeeBaseVo.getDepartment())) {
                logger.info("\u5458\u5de5\u6240\u5c5e\u7ec4\u7ec7id\u5217\u8868\u4e3a\u7a7a\u6216\u4e0d\u5728\u4efb\u4e00\u4eba\u529b\u7ec4\u7ec7\u4e0b\uff0c\u5220\u9664\u5458\u5de5\u6570\u636e\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)employeeVo));
                boolean result = EmployeeUtil.batchDeleteEmployee(accessToken, Collections.singletonList(employeeThirdReqDto.getThirdEmployeeId()));
                if (result) {
                    this.employeeThirdService.removeUserThird(employeeVo.getEmployeeId(), ThirdTypeEnum.ENTERPRISE_WECHAT.getType());
                }
                return;
            }
            EmployeeUtil.updateEmployee(accessToken, employeeBaseVo);
        }
    }

    private EmployeeThirdReqDto getEmployeeThirdReqDto(Long id, String paramJson) {
        EmployeeThirdReqDto employeeThirdReqDto = this.employeeThirdService.queryById(id, ThirdTypeEnum.ENTERPRISE_WECHAT.getType());
        if (employeeThirdReqDto == null) {
            logger.info("\u672a\u67e5\u8be2\u5230\u5458\u5de5id-\u4f01\u4e1a\u5fae\u4fe1\u5458\u5de5id\u7ed1\u5b9a\u5173\u7cfb\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)paramJson);
            return null;
        }
        return employeeThirdReqDto;
    }

    @Override
    public void batchDeleteEmployee(List<Long> employeeIds) {
        String accessToken = this.weChatService.getAccessToken(JSONObject.toJSONString(employeeIds));
        if (accessToken == null) {
            return;
        }
        List eoList = this.employeeThirdService.queryByIdList(employeeIds, ThirdTypeEnum.ENTERPRISE_WECHAT.getType());
        if (CollectionUtil.isEmpty((Collection)eoList)) {
            logger.info("\u672a\u67e5\u8be2\u5230\u5458\u5de5id-\u4f01\u4e1a\u5458\u5de5id\u7ed1\u5b9a\u5173\u7cfb\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString(employeeIds));
            return;
        }
        List<String> userIds = eoList.stream().map(StdEmployeeThirdEo::getThirdEmployeeId).collect(Collectors.toList());
        boolean result = EmployeeUtil.batchDeleteEmployee(accessToken, userIds);
        if (result) {
            this.employeeThirdService.deleteByIdList(employeeIds, ThirdTypeEnum.ENTERPRISE_WECHAT.getType());
        }
    }

    @Override
    public boolean batchUpdateOrDeleteEmployee(Long departmentId) {
        String accessToken = this.weChatService.getAccessToken(JSONObject.toJSONString((Object)departmentId));
        if (accessToken == null) {
            return false;
        }
        String employee = EmployeeUtil.listSimpleEmployee(accessToken, departmentId, 0);
        if (employee == null) {
            logger.info("\u672a\u67e5\u8be2\u5230\u4f01\u4e1a\u5fae\u4fe1\u5458\u5de5\u4fe1\u606f\uff0c\u90e8\u95e8id:{}", (Object)departmentId);
            return true;
        }
        List list = JSONObject.parseArray((String)employee, EmployeeBaseVo.class);
        if (CollectionUtil.isEmpty((Collection)list)) {
            logger.info("\u672a\u67e5\u8be2\u5230\u4f01\u4e1a\u5fae\u4fe1\u5458\u5de5\u4fe1\u606f\uff0c\u90e8\u95e8id:{}", (Object)departmentId);
            return true;
        }
        boolean result = true;
        for (EmployeeBaseVo employeeBaseVo : list) {
            List<Long> department = employeeBaseVo.getDepartment();
            department.remove(departmentId);
            if (CollectionUtil.isEmpty(department)) {
                result = EmployeeUtil.batchDeleteEmployee(accessToken, Collections.singletonList(employeeBaseVo.getUserid()));
                if (!result) break;
                this.employeeThirdService.deleteByThirdEmployeeIdList(Collections.singletonList(employeeBaseVo.getUserid()), ThirdTypeEnum.ENTERPRISE_WECHAT.getType());
                continue;
            }
            EmployeeBaseVo updateVo = new EmployeeBaseVo();
            updateVo.setUserid(employeeBaseVo.getUserid());
            updateVo.setDepartment(department);
            result = EmployeeUtil.updateEmployee(accessToken, updateVo);
            if (result) continue;
            break;
        }
        return result;
    }

    @Override
    public void batchUpdateEmployeePost(List<Long> employeeIds) {
        String accessToken = this.weChatService.getAccessToken(JSONObject.toJSONString(employeeIds));
        if (accessToken == null) {
            return;
        }
        List eoList = this.employeeThirdService.queryByIdList(employeeIds, ThirdTypeEnum.ENTERPRISE_WECHAT.getType());
        if (CollectionUtil.isEmpty((Collection)eoList)) {
            logger.info("\u672a\u67e5\u8be2\u5230\u5458\u5de5id-\u4f01\u4e1a\u5458\u5de5id\u7ed1\u5b9a\u5173\u7cfb\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString(employeeIds));
            return;
        }
        List ids = eoList.stream().map(StdEmployeeThirdEo::getEmployeeId).collect(Collectors.toList());
        List employeePostEoList = this.employeePostDas.queryByEmployeeIds(ids);
        if (CollectionUtil.isEmpty((Collection)employeePostEoList)) {
            logger.info("\u5458\u5de5\u672a\u5173\u8054\u5c97\u4f4d\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString(ids));
            return;
        }
        List postIds = employeePostEoList.parallelStream().map(StdEmployeePostEo::getPostId).collect(Collectors.toList());
        List postEoList = this.postDas.queryByIds(postIds);
        if (CollectionUtil.isEmpty((Collection)postEoList)) {
            logger.info("\u672a\u67e5\u8be2\u5230\u5c97\u4f4d\u4fe1\u606f\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString(postIds));
            return;
        }
        Map<Long, List<EmployeePostEo>> employeeId2EmployeePostEoListMap = employeePostEoList.parallelStream().collect(Collectors.groupingBy(StdEmployeePostEo::getEmployeeId));
        Map<Long, String> postId2PostNameMap = postEoList.parallelStream().collect(Collectors.toMap(BaseEo::getId, StdPostEo::getName));
        eoList.forEach(eo -> {
            EmployeeBaseVo employeeBaseVo = new EmployeeBaseVo();
            employeeBaseVo.setUserid(eo.getThirdEmployeeId());
            List employeePostEos = (List)employeeId2EmployeePostEoListMap.get(eo.getEmployeeId());
            if (CollectionUtil.isNotEmpty((Collection)employeePostEos)) {
                ArrayList postNames = new ArrayList();
                employeePostEos.forEach(employeePostEo -> {
                    String postName = (String)postId2PostNameMap.get(employeePostEo.getPostId());
                    if (postName != null) {
                        postNames.add(postName);
                    }
                });
                employeeBaseVo.setPosition(StringUtils.join(postNames, (String)","));
            } else {
                employeeBaseVo.setPosition("");
            }
            EmployeeUtil.updateEmployee(accessToken, employeeBaseVo);
        });
    }

    @Override
    public void batchUpdateEmployeeStatus(List<Long> employeeIds, Integer status) {
        String accessToken = this.weChatService.getAccessToken(JSONObject.toJSONString(employeeIds));
        if (accessToken == null) {
            return;
        }
        List eoList = this.employeeThirdService.queryByIdList(employeeIds, ThirdTypeEnum.ENTERPRISE_WECHAT.getType());
        if (CollectionUtil.isEmpty((Collection)eoList)) {
            logger.info("\u672a\u67e5\u8be2\u5230\u5458\u5de5id-\u4f01\u4e1a\u5458\u5de5id\u7ed1\u5b9a\u5173\u7cfb\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString(employeeIds));
            return;
        }
        Integer enable = EmployeeUtil.getEnable(status);
        eoList.forEach(employeeThirdEo -> {
            EmployeeBaseVo employeeBaseVo = new EmployeeBaseVo();
            employeeBaseVo.setUserid(employeeThirdEo.getThirdEmployeeId());
            employeeBaseVo.setEnable(enable);
            EmployeeUtil.updateEmployee(accessToken, employeeBaseVo);
        });
    }

    @Override
    public List<WeChatEmployeeRespDto> queryFollowUserList(FollowUserReqDto followUserReqDto) {
        String accessToken = this.getAccessToken(followUserReqDto.getQueryType(), followUserReqDto.getChannelAccount(), followUserReqDto.getAppInstanceId());
        String followUserList = ExternalContactUtil.getFollowUserList(accessToken);
        List userIds = JSONObject.parseArray((String)followUserList, String.class);
        return this.departmentService.getEmployeeRespDtoList(userIds, new OrgAndEmployeeReqDto());
    }

    private String getAccessToken(Integer queryType, String channelAccount, Long appInstanceId) {
        String accessToken;
        if (queryType == 1) {
            AssertUtil.isTrue((boolean)StrUtil.isNotBlank((CharSequence)channelAccount), (String)"\u6e20\u9053\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            accessToken = this.weChatService.getExternalContactAccessToken(channelAccount);
        } else {
            AssertUtil.isTrue((appInstanceId != null ? 1 : 0) != 0, (String)"\u5e94\u7528\u5b9e\u4f8bid\u4e0d\u80fd\u4e3a\u7a7a");
            AppInstanceEo appInstanceEo = (AppInstanceEo)this.appInstanceDas.selectByPrimaryKey(appInstanceId);
            if (appInstanceEo == null) {
                throw new BizException("500", "\u5e94\u7528\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            String instanceConfig = appInstanceEo.getInstanceConfig();
            if (StrUtil.isBlank((CharSequence)appInstanceEo.getAccount()) || StrUtil.isBlank((CharSequence)instanceConfig)) {
                throw new BizException("500", "\u5e94\u7528\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\u6216\u4e0d\u5b8c\u6574");
            }
            WeChatConfigVo weChatConfigVo = (WeChatConfigVo)JSON.parseObject((String)instanceConfig, WeChatConfigVo.class);
            accessToken = this.weChatService.getAccessToken(appInstanceEo.getAccount(), weChatConfigVo.getAppSecret());
        }
        if (accessToken == null) {
            throw new BizException("500", "\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1AccessToken\u5931\u8d25");
        }
        return accessToken;
    }

    @Override
    public String getExternalContactByUser(ExternalContactReqDto externalContactReqDto) {
        String accessToken = this.getAccessToken(externalContactReqDto.getQueryType(), externalContactReqDto.getChannelAccount(), externalContactReqDto.getAppInstanceId());
        JSONObject result = ExternalContactUtil.getByUser(accessToken, externalContactReqDto.getUserId(), externalContactReqDto.getCursor(), externalContactReqDto.getLimit());
        if (result.getIntValue("errcode") != 0) {
            logger.error("\u6279\u91cf\u83b7\u53d6\u5ba2\u6237\u8be6\u60c5\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)externalContactReqDto), (Object)result.toJSONString());
            throw new BizException("500", "\u6279\u91cf\u83b7\u53d6\u5ba2\u6237\u8be6\u60c5\u5931\u8d25");
        }
        return result.toJSONString();
    }

    @Override
    public String getGroupChatList(GroupChatReqDto groupChatReqDto) {
        String accessToken = this.getAccessToken(groupChatReqDto.getQueryType(), groupChatReqDto.getChannelAccount(), groupChatReqDto.getAppInstanceId());
        JSONObject result = ExternalContactUtil.getGroupChatList(accessToken, groupChatReqDto);
        if (result.getIntValue("errcode") != 0) {
            logger.error("\u83b7\u53d6\u5ba2\u6237\u7fa4\u5217\u8868\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)groupChatReqDto), (Object)result.toJSONString());
            throw new BizException("500", "\u83b7\u53d6\u5ba2\u6237\u7fa4\u5217\u8868\u5931\u8d25");
        }
        return result.toJSONString();
    }

    @Override
    public String getGroupChatDetail(GroupChatDetailReqDto groupChatDetailReqDto) {
        String accessToken = this.getAccessToken(groupChatDetailReqDto.getQueryType(), groupChatDetailReqDto.getChannelAccount(), groupChatDetailReqDto.getAppInstanceId());
        JSONObject result = ExternalContactUtil.getGroupChatDetail(accessToken, groupChatDetailReqDto.getChatId());
        if (result.getIntValue("errcode") != 0) {
            logger.error("\u83b7\u53d6\u5ba2\u6237\u7fa4\u8be6\u60c5\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)groupChatDetailReqDto), (Object)result.toJSONString());
            throw new BizException("500", "\u83b7\u53d6\u5ba2\u6237\u7fa4\u8be6\u60c5\u5931\u8d25");
        }
        return result.toJSONString();
    }
}

