/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.wechat.org.biz.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.channel.api.IExternalChannelDataApi;
import com.dtyunxi.yundt.cube.center.channel.api.dto.request.AccessTokenReqDto;
import com.dtyunxi.yundt.cube.center.channel.api.dto.request.ChannelAccountReqDto;
import com.dtyunxi.yundt.cube.center.channel.api.dto.wechat.WechatTokenReqDto;
import com.dtyunxi.yundt.cube.center.channel.api.query.IChannelAccountQueryApi;
import com.dtyunxi.yundt.cube.center.wechat.org.biz.service.IWeChatService;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class WeChatServiceImpl
implements IWeChatService {
    private static Logger logger = LoggerFactory.getLogger(WeChatServiceImpl.class);
    private static final Integer WE_CHAT_ACCOUNT_TYPE = 8;
    @Resource
    private IExternalChannelDataApi externalChannelDataApi;
    @Resource
    private IChannelAccountQueryApi channelAccountQueryApi;

    @Override
    public String getAccessToken(String paramJson) {
        RestResponse restResponse = this.externalChannelDataApi.getAccessToken(WE_CHAT_ACCOUNT_TYPE, false);
        return this.getAccessToken(paramJson, (RestResponse<String>)restResponse);
    }

    private String getAccessToken(String paramJson, RestResponse<String> restResponse) {
        String accessToken = null;
        if ("0".equals(restResponse.getResultCode()) && StringUtils.isNotBlank((CharSequence)((CharSequence)restResponse.getData()))) {
            accessToken = (String)restResponse.getData();
        }
        if (accessToken == null) {
            logger.error("\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1AccessToken\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)paramJson, (Object)JSONObject.toJSONString(restResponse));
        }
        return accessToken;
    }

    @Override
    public String getDepartmentAccessToken(String channelAccount) {
        RestResponse restResponse = this.externalChannelDataApi.getAccessToken(channelAccount, WE_CHAT_ACCOUNT_TYPE, false);
        return this.getAccessToken(channelAccount, (RestResponse<String>)restResponse);
    }

    @Override
    public String getAccessToken(String appId, String appSecret) {
        AccessTokenReqDto reqDto = new AccessTokenReqDto();
        reqDto.setAppId(appId);
        reqDto.setAppSecret(appSecret);
        reqDto.setType(WE_CHAT_ACCOUNT_TYPE);
        RestResponse restResponse = this.externalChannelDataApi.getAccessToken(reqDto);
        return this.getAccessToken(JSON.toJSONString((Object)reqDto), (RestResponse<String>)restResponse);
    }

    @Override
    public String getExternalContactAccessToken(String channelAccount) {
        RestResponse restResponse = this.channelAccountQueryApi.queryByAccount(channelAccount, WE_CHAT_ACCOUNT_TYPE);
        if ("0".equals(restResponse.getResultCode())) {
            ChannelAccountReqDto channelAccountReqDto = (ChannelAccountReqDto)restResponse.getData();
            WechatTokenReqDto wechatTokenReqDto = (WechatTokenReqDto)JSONObject.parseObject((String)channelAccountReqDto.getConfig(), WechatTokenReqDto.class);
            if (wechatTokenReqDto == null) {
                throw new BizException("500", "\u4f01\u4e1a\u5fae\u4fe1\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a");
            }
            if (StrUtil.isBlank((CharSequence)wechatTokenReqDto.getAppId())) {
                throw new BizException("500", "\u4f01\u4e1a\u5fae\u4fe1appId\u672a\u914d\u7f6e");
            }
            if (StrUtil.isBlank((CharSequence)wechatTokenReqDto.getContactSecret())) {
                throw new BizException("500", "\u4f01\u4e1a\u5fae\u4fe1\u5ba2\u6237\u8054\u7cfbSecret\u672a\u914d\u7f6e");
            }
            return this.getAccessToken(wechatTokenReqDto.getAppId(), wechatTokenReqDto.getContactSecret());
        }
        logger.error("\u67e5\u8be2\u6e20\u9053\u8d26\u53f7\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)channelAccount);
        throw new BizException("500", "\u67e5\u8be2\u6e20\u9053\u8d26\u53f7\u4fe1\u606f\u5931\u8d25");
    }
}

