/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.wechat.org.biz.util;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.yundt.cube.center.wechat.org.biz.vo.DepartmentCreateVo;
import com.dtyunxi.yundt.cube.center.wechat.org.biz.vo.DepartmentUpdateVo;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class DepartmentUtil {
    private static Logger logger = LoggerFactory.getLogger(DepartmentUtil.class);
    public static final String DEPARTMENT_CREATE_URL = "https://qyapi.weixin.qq.com/cgi-bin/department/create?access_token=%s";
    public static final String DEPARTMENT_UPDATE_URL = "https://qyapi.weixin.qq.com/cgi-bin/department/update?access_token=%s";
    public static final String DEPARTMENT_DELETE_URL = "https://qyapi.weixin.qq.com/cgi-bin/department/delete?access_token=%s&id=%s";
    public static final String DEPARTMENT_LIST_URL = "https://qyapi.weixin.qq.com/cgi-bin/department/list?access_token=%s";
    public static final String AGENT_GET_URL = "https://qyapi.weixin.qq.com/cgi-bin/agent/get?access_token=%s&agentid=%s";

    public static String createDepartment(String accessToken, DepartmentCreateVo createVo) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        Map params = BeanUtil.beanToMap((Object)createVo);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        String url = String.format(DEPARTMENT_CREATE_URL, accessToken);
        RestTemplate restTemplate = new RestTemplate();
        JSONObject resultJson = (JSONObject)restTemplate.postForObject(url, (Object)request, JSONObject.class, new Object[0]);
        String id = null;
        String errcode = resultJson.getString("errcode");
        if ("0".equals(errcode)) {
            id = resultJson.getString("id");
        } else {
            logger.error("\u521b\u5efa\u4f01\u4e1a\u5fae\u4fe1\u90e8\u95e8\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)createVo), (Object)resultJson.toJSONString());
        }
        return id;
    }

    public static boolean updateDepartment(String accessToken, DepartmentUpdateVo updateVo) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        Map params = BeanUtil.beanToMap((Object)updateVo);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        String url = String.format(DEPARTMENT_UPDATE_URL, accessToken);
        RestTemplate restTemplate = new RestTemplate();
        JSONObject resultJson = (JSONObject)restTemplate.postForObject(url, (Object)request, JSONObject.class, new Object[0]);
        boolean result = false;
        String errcode = resultJson.getString("errcode");
        if ("0".equals(errcode)) {
            result = true;
        } else {
            logger.error("\u66f4\u65b0\u4f01\u4e1a\u5fae\u4fe1\u90e8\u95e8\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)updateVo), (Object)resultJson.toJSONString());
        }
        return result;
    }

    public static boolean deleteDepartment(String accessToken, Long id) {
        RestTemplate restTemplate = new RestTemplate();
        String url = String.format(DEPARTMENT_DELETE_URL, accessToken, id);
        JSONObject resultJson = (JSONObject)restTemplate.getForObject(url, JSONObject.class, new Object[0]);
        boolean result = false;
        String errcode = resultJson.getString("errcode");
        if ("0".equals(errcode)) {
            result = true;
        } else {
            logger.error("\u5220\u9664\u4f01\u4e1a\u5fae\u4fe1\u90e8\u95e8\u5931\u8d25\uff0c\u90e8\u95e8id\uff1a{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)id, (Object)resultJson.toJSONString());
        }
        return result;
    }

    public static String listDepartment(String accessToken, Long id) {
        RestTemplate restTemplate = new RestTemplate();
        String url = String.format(DEPARTMENT_LIST_URL, accessToken);
        if (id != null) {
            url = url + "&id=" + id;
        }
        JSONObject resultJson = (JSONObject)restTemplate.getForObject(url, JSONObject.class, new Object[0]);
        String result = null;
        String errcode = resultJson.getString("errcode");
        if ("0".equals(errcode)) {
            result = resultJson.getJSONArray("department").toJSONString();
        } else {
            logger.error("\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1\u90e8\u95e8\u5217\u8868\u5931\u8d25\uff0c\u90e8\u95e8id\uff1a{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)id, (Object)resultJson.toJSONString());
        }
        return result;
    }

    public static String getAgentInfo(String accessToken, String agentId) {
        RestTemplate restTemplate = new RestTemplate();
        String url = String.format(AGENT_GET_URL, accessToken, agentId);
        JSONObject resultJson = (JSONObject)restTemplate.getForObject(url, JSONObject.class, new Object[0]);
        String result = null;
        String errcode = resultJson.getString("errcode");
        if ("0".equals(errcode)) {
            result = resultJson.toJSONString();
        } else {
            logger.error("\u83b7\u53d6\u6307\u5b9a\u7684\u5e94\u7528\u8be6\u60c5\u5931\u8d25\uff0c\u5e94\u7528id\uff1a{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)agentId, (Object)resultJson.toJSONString());
        }
        return result;
    }
}

