/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.wechat.org.biz.util;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.yundt.cube.center.wechat.org.biz.vo.EmployeeBaseVo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class EmployeeUtil {
    private static Logger logger = LoggerFactory.getLogger(EmployeeUtil.class);
    public static final String USER_CREATE_URL = "https://qyapi.weixin.qq.com/cgi-bin/user/create?access_token=%s";
    public static final String USER_UPDATE_URL = "https://qyapi.weixin.qq.com/cgi-bin/user/update?access_token=%s";
    public static final String USER_BATCH_DELETE_URL = "https://qyapi.weixin.qq.com/cgi-bin/user/batchdelete?access_token=%s";
    public static final String USER_LIST_URL = "https://qyapi.weixin.qq.com/cgi-bin/user/list?access_token=%s&department_id=%s&fetch_child=%s";
    public static final String USER_SIMPLE_LIST_URL = "https://qyapi.weixin.qq.com/cgi-bin/user/simplelist?access_token=%s&department_id=%s&fetch_child=%S";

    public static boolean createEmployee(String accessToken, EmployeeBaseVo baseVo) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        Map params = BeanUtil.beanToMap((Object)baseVo);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        String url = String.format(USER_CREATE_URL, accessToken);
        RestTemplate restTemplate = new RestTemplate();
        JSONObject resultJson = (JSONObject)restTemplate.postForObject(url, (Object)request, JSONObject.class, new Object[0]);
        boolean result = false;
        String errcode = resultJson.getString("errcode");
        if ("0".equals(errcode)) {
            result = true;
        } else {
            logger.error("\u521b\u5efa\u4f01\u4e1a\u5458\u5de5\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)baseVo), (Object)resultJson.toJSONString());
        }
        return result;
    }

    public static boolean updateEmployee(String accessToken, EmployeeBaseVo baseVo) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        Map params = BeanUtil.beanToMap((Object)baseVo);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        String url = String.format(USER_UPDATE_URL, accessToken);
        RestTemplate restTemplate = new RestTemplate();
        JSONObject resultJson = (JSONObject)restTemplate.postForObject(url, (Object)request, JSONObject.class, new Object[0]);
        boolean result = false;
        String errcode = resultJson.getString("errcode");
        if ("0".equals(errcode)) {
            result = true;
        } else {
            logger.error("\u66f4\u65b0\u4f01\u4e1a\u5458\u5de5\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)baseVo), (Object)resultJson.toJSONString());
        }
        return result;
    }

    public static boolean batchDeleteEmployee(String accessToken, List<String> employeeIds) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, List<String>> params = new HashMap<String, List<String>>(1);
        params.put("useridlist", employeeIds);
        HttpEntity request = new HttpEntity(params, (MultiValueMap)headers);
        String url = String.format(USER_BATCH_DELETE_URL, accessToken);
        RestTemplate restTemplate = new RestTemplate();
        JSONObject resultJson = (JSONObject)restTemplate.postForObject(url, (Object)request, JSONObject.class, new Object[0]);
        boolean result = false;
        String errcode = resultJson.getString("errcode");
        if ("0".equals(errcode)) {
            result = true;
        } else {
            logger.error("\u5220\u9664\u4f01\u4e1a\u5458\u5de5\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString(employeeIds), (Object)resultJson.toJSONString());
        }
        return result;
    }

    public static String listEmployee(String accessToken, Long departmentId, int fetchChild) {
        RestTemplate restTemplate = new RestTemplate();
        String url = String.format(USER_LIST_URL, accessToken, departmentId, fetchChild);
        JSONObject resultJson = (JSONObject)restTemplate.getForObject(url, JSONObject.class, new Object[0]);
        String result = null;
        String errcode = resultJson.getString("errcode");
        if ("0".equals(errcode)) {
            result = resultJson.getJSONArray("userlist").toJSONString();
        } else {
            logger.error("\u83b7\u53d6\u4f01\u4e1a\u5458\u5de5\u5217\u8868\u5931\u8d25\uff0c\u90e8\u95e8id\uff1a{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)departmentId, (Object)resultJson.toJSONString());
        }
        return result;
    }

    public static String listSimpleEmployee(String accessToken, Long departmentId, int fetchChild) {
        RestTemplate restTemplate = new RestTemplate();
        String url = String.format(USER_SIMPLE_LIST_URL, accessToken, departmentId, fetchChild);
        JSONObject resultJson = (JSONObject)restTemplate.getForObject(url, JSONObject.class, new Object[0]);
        String result = null;
        String errcode = resultJson.getString("errcode");
        if ("0".equals(errcode)) {
            result = resultJson.getJSONArray("userlist").toJSONString();
        } else {
            logger.error("\u83b7\u53d6\u4f01\u4e1a\u5458\u5de5\u5217\u8868\u5931\u8d25\uff0c\u90e8\u95e8id\uff1a{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)departmentId, (Object)resultJson.toJSONString());
        }
        return result;
    }

    public static Integer getEnable(Integer status) {
        if (status == null) {
            return 1;
        }
        return 1 == status ? 1 : 0;
    }
}

