/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.wechat.org.biz.util;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.yundt.cube.center.wechat.org.api.dto.request.GroupChatReqDto;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class ExternalContactUtil {
    private static Logger logger = LoggerFactory.getLogger(ExternalContactUtil.class);
    public static final String GET_FOLLOW_USER_LIST = "https://qyapi.weixin.qq.com/cgi-bin/externalcontact/get_follow_user_list?access_token=%s";
    public static final String GET_BY_USER = "https://qyapi.weixin.qq.com/cgi-bin/externalcontact/batch/get_by_user?access_token=%s";
    public static final String GET_GROUP_CHAT_LIST = "https://qyapi.weixin.qq.com/cgi-bin/externalcontact/groupchat/list?access_token=%s";
    public static final String GET_GROUP_CHAT_DETAIL = "https://qyapi.weixin.qq.com/cgi-bin/externalcontact/groupchat/get?access_token=%s";

    public static String getFollowUserList(String accessToken) {
        RestTemplate restTemplate = new RestTemplate();
        String url = String.format(GET_FOLLOW_USER_LIST, accessToken);
        JSONObject resultJson = (JSONObject)restTemplate.getForObject(url, JSONObject.class, new Object[0]);
        String result = null;
        String errcode = resultJson.getString("errcode");
        if ("0".equals(errcode)) {
            result = resultJson.getJSONArray("follow_user").toJSONString();
        } else {
            logger.error("\u83b7\u53d6\u914d\u7f6e\u4e86\u5ba2\u6237\u8054\u7cfb\u529f\u80fd\u7684\u6210\u5458\u5217\u8868\u5931\u8d25");
        }
        return result;
    }

    public static JSONObject getByUser(String accessToken, String userId, String cursor, Integer limit) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userid", userId);
        params.put("cursor", cursor);
        params.put("limit", limit);
        HttpEntity request = new HttpEntity(params, (MultiValueMap)headers);
        String url = String.format(GET_BY_USER, accessToken);
        RestTemplate restTemplate = new RestTemplate();
        return (JSONObject)restTemplate.postForObject(url, (Object)request, JSONObject.class, new Object[0]);
    }

    public static JSONObject getGroupChatList(String accessToken, GroupChatReqDto groupChatReqDto) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("status_filter", groupChatReqDto.getStatusFilter());
        params.put("owner_filter", groupChatReqDto.getOwnerFilter());
        params.put("cursor", groupChatReqDto.getCursor());
        params.put("limit", groupChatReqDto.getLimit());
        HttpEntity request = new HttpEntity(params, (MultiValueMap)headers);
        String url = String.format(GET_GROUP_CHAT_LIST, accessToken);
        RestTemplate restTemplate = new RestTemplate();
        return (JSONObject)restTemplate.postForObject(url, (Object)request, JSONObject.class, new Object[0]);
    }

    public static JSONObject getGroupChatDetail(String accessToken, String chatId) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("chat_id", chatId);
        HttpEntity request = new HttpEntity(params, (MultiValueMap)headers);
        String url = String.format(GET_GROUP_CHAT_DETAIL, accessToken);
        RestTemplate restTemplate = new RestTemplate();
        return (JSONObject)restTemplate.postForObject(url, (Object)request, JSONObject.class, new Object[0]);
    }
}

