package com.dtyunxi.yundt.dataengine.center.report.api.icommerce.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

@ApiModel(value = "ItemRankingReqDto", description = "商品分析商品排行请求dto")
public class ItemRankingReqDto extends BasePageReqDto{
    @ApiModelProperty(name = "sellerId", value = "商家ID")
    private Long sellerId;

    @ApiModelProperty(name = "shopType", value = "店铺类型")
    private Integer shopType;

    @ApiModelProperty(name = "shopId", value = "店铺ID")
    private Long shopId;

    @ApiModelProperty(name = "timeType", value = "统计时间类型（customize：自定义，day：日，week：周，month：月）")
    @NotNull(message = "统计时间类型不能为空")
    private String timeType;

    @ApiModelProperty(name = "startTime", value = "开始时间")
    @NotNull(message = "开始时间不能为空")
    private String startTime;

    @ApiModelProperty(name = "endTime", value = "结束时间")
    @NotNull(message = "结束时间不能为空")
    private String endTime;

    @ApiModelProperty(name = "rankingType", value = "排行类型（支付金额：paidAmt，支付笔数：paidItemNum）")
    @NotNull(message = "排行类型不能为空")
    private String rankingType;

    public String getRankingType() {
        return rankingType;
    }

    public void setRankingType(String rankingType) {
        this.rankingType = rankingType;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Integer getShopType() {
        return shopType;
    }

    public void setShopType(Integer shopType) {
        this.shopType = shopType;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public String getTimeType() {
        return timeType;
    }

    public void setTimeType(String timeType) {
        this.timeType = timeType;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }
}
