package com.dtyunxi.yundt.dataengine.center.report.api.icommerce.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * 流量分析-页面访问分析排序字段枚举类
 */
public enum ActivityByPageSortFieldEnum {
    PV("pv","浏览量"),
    UV("uv","访客量"),
    TOTALPVTD("totalPvTd","累计浏览量"),
    TOTALPVPERCENTAGE("totalPvPercentage","累计浏览量占比"),
    TOTALUVTD("totalUvTd","累计访客量"),
    TOTALUVPERCENTAGE("totalUvPercentage","累计访客量占比")
    ;
    private final String code;

    private final String name;


    public static ActivityByPageSortFieldEnum getByCode(String code){
        if(StringUtils.isBlank(code)){
            return null;
        }
        for(ActivityByPageSortFieldEnum activityByPageSortFieldEnum : ActivityByPageSortFieldEnum.values()){
            if(activityByPageSortFieldEnum.getCode().equals(code)){
                return activityByPageSortFieldEnum;
            }
        }
        return null;
    }

    ActivityByPageSortFieldEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public String getCode() {
        return code;
    }
}
