package com.dtyunxi.yundt.dataengine.center.report.api.icommerce.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * 商品分析-销售明细排序字段枚举类
 */
public enum SalesDetailSortFieldEnum {
    PV("pv","访问量"),
    ADDCARTCUSTCNT("add_cart_cust_cnt","加购人数"),
    PAIDITEMNUM("paid_item_num","支付商品件数(销量)"),
    PAIDAMT("paid_amt","支付金额"),
    SUCCREFUNDITEMNUM("succ_refund_item_num","成功退货/退款商品件数(退款件数)"),
    SUCCREFUNDAMT("succ_refund_amt","成功退款金额"),
    VISITORDERCONVRATE("visit_order_conv_rate","浏览下单转化率(下单转化率)"),
    ORDERPAYCONVRATE("order_pay_conv_rate","下单支付转化率"),
    VISITPAYCONVRATE("visit_pay_conv_rate","支付转化率"),
    REFUNDRATE("refund_rate","退款率"),
    ;
    private final String code;

    private final String name;


    public static SalesDetailSortFieldEnum getByCode(String code){
        if(StringUtils.isBlank(code)){
            return null;
        }
        for(SalesDetailSortFieldEnum salesDetailSortFieldEnum : SalesDetailSortFieldEnum.values()){
            if(salesDetailSortFieldEnum.getCode().equals(code)){
                return salesDetailSortFieldEnum;
            }
        }
        return null;
    }

    SalesDetailSortFieldEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public String getCode() {
        return code;
    }
}
