package com.dtyunxi.yundt.dataengine.center.report.api.icommerce.evaluate;


import com.dtyunxi.rest.Page;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.dataengine.center.report.api.icommerce.dto.request.*;
import com.dtyunxi.yundt.dataengine.center.report.api.icommerce.dto.response.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;

import javax.validation.Valid;
import java.util.List;

@FeignClient(name = "${dataengine.center.report:dataengine-center-report}",
        path = "/dataengine-center-report/v1/icommerce/activityflow/analyze",
        url = "${dataengine.center.report.name.api:}"
)
@Api(tags = {"流量分析"})
public interface IActivityFlowAnalyeApi {
    @GetMapping("/activityOverview")
    @ApiOperation(value = "商城流量概览")
    RestResponse<ActivityOverviewRespDto> activityOverview(@Valid ActivityOverviewBaseReqDto reqDto);

    @GetMapping("/activityOverviewDetail")
    @ApiOperation(value = "商城流量概览详情")
    RestResponse<List<ActivityOverviewDetailRespDto>> activityOverviewDetail(@Valid ActivityOverviewBaseReqDto reqDto);

    @GetMapping("/activityAnalyeBySource")
    @ApiOperation(value = "访问来源分析")
    RestResponse<Page<ActivityAnalyeBySourceRespDto>> activityAnalyeBySource(@Valid ActivityAnalyeBySourcePageReqDto reqDto);

    @GetMapping("/activityAnalyeByShop")
    @ApiOperation(value = "店铺流量分析")
    RestResponse<Page<ActivityAnalyeByShopRespDto>> activityAnalyeByShop(@Valid ActivityAnalyeByShopPageReqDto reqDto);

    @GetMapping("/activityAnalyeByPage")
    @ApiOperation(value = "页面访问分析")
    RestResponse<Page<ActivityAnalyeByPageRespDto>> activityAnalyeByPage(@Valid ActivityAnalyeByPagePageReqDto reqDto);
}
