package com.dtyunxi.yundt.dataengine.center.report.api.icommerce.evaluate;

import com.dtyunxi.rest.Page;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.dataengine.center.report.api.icommerce.dto.request.ItemCategoryPercentageReqDto;
import com.dtyunxi.yundt.dataengine.center.report.api.icommerce.dto.request.ItemCategoryRankingReqDto;
import com.dtyunxi.yundt.dataengine.center.report.api.icommerce.dto.request.ItemRankingReqDto;
import com.dtyunxi.yundt.dataengine.center.report.api.icommerce.dto.request.ItemSalesDetailReqDto;
import com.dtyunxi.yundt.dataengine.center.report.api.icommerce.dto.response.ItemCategoryPercentageRespDto;
import com.dtyunxi.yundt.dataengine.center.report.api.icommerce.dto.response.ItemCategoryRankingRespDto;
import com.dtyunxi.yundt.dataengine.center.report.api.icommerce.dto.response.ItemRankingRespDto;
import com.dtyunxi.yundt.dataengine.center.report.api.icommerce.dto.response.ItemSalesDetailRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;

import javax.validation.Valid;
import java.util.List;

@FeignClient(name = "${dataengine.center.report:dataengine-center-report}",
        path = "/dataengine-center-report/v1/icommerce/item/analyze",
        url = "${dataengine.center.report.name.api:}"
)
@Api(tags={"商品分析：商品分析"})
public interface IItemAnalyzeApi {

    @GetMapping("/category/ranking")
    @ApiOperation(value = "商品后台类目排行")
    RestResponse<Page<ItemCategoryRankingRespDto>> itemCategoryRanking(@Valid ItemCategoryRankingReqDto reqDto);

    @GetMapping("/item/ranking")
    @ApiOperation(value = "商品排行")
    RestResponse<Page<ItemRankingRespDto>> itemRanking(@Valid ItemRankingReqDto reqDto);

    @GetMapping("/category/percentage")
    @ApiOperation(value = "类目占比")
    RestResponse<List<ItemCategoryPercentageRespDto>> categoryPercentage(@Valid ItemCategoryPercentageReqDto reqDto);

    @GetMapping("/sales/detail")
    @ApiOperation(value = "销售明细")
    RestResponse<Page<ItemSalesDetailRespDto>> salesDetail(@Valid ItemSalesDetailReqDto reqDto);


}
