package com.dtyunxi.yundt.dataengine.center.report.api.icommerce.evaluate;

import com.dtyunxi.rest.Page;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.dataengine.center.report.api.icommerce.dto.request.ItemRecommendPageReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;

import javax.validation.Valid;

@FeignClient(name = "${dataengine.center.report:dataengine-center-report}",
        path = "/dataengine-center-report/v1/icommerce/item/recommend",
        url = "${dataengine.center.report.name.api:}"
)
@Api(tags={"商品推荐"})
public interface IItemRecommendApi {

    @GetMapping("/itemRecommend")
    @ApiOperation(value = "商品推荐")
    RestResponse<Page<Long>> itemRecommend(@Valid ItemRecommendPageReqDto reqDto);

}
