package com.dtyunxi.yundt.dataengine.center.report.api.icommerce.evaluate;


import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.dataengine.center.report.api.icommerce.dto.request.UserOverviewReqDto;
import com.dtyunxi.yundt.dataengine.center.report.api.icommerce.dto.request.UserRetentionReqDto;
import com.dtyunxi.yundt.dataengine.center.report.api.icommerce.dto.response.UserRetentionRespDto;
import com.dtyunxi.yundt.dataengine.center.report.api.icommerce.dto.response.UserOverviewDetailRespDto;
import com.dtyunxi.yundt.dataengine.center.report.api.icommerce.dto.response.UserOverviewRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;

import javax.validation.Valid;
import java.util.List;

@FeignClient(name = "${dataengine.center.report:dataengine-center-report}",
        path = "/dataengine-center-report/v1/icommerce/user/analyze",
        url = "${dataengine.center.report.name.api:}"
)
@Api(tags = {"用户分析"})
public interface IUserAnalyzeApi {
    @GetMapping("/userOverview")
    @ApiOperation(value = "用户概览")
    RestResponse<UserOverviewRespDto> userOverview(@Valid UserOverviewReqDto reqDto);

    @GetMapping("/userOverviewDetail")
    @ApiOperation(value = "用户概览详情")
    RestResponse<List<UserOverviewDetailRespDto>> userOverviewDetail(@Valid UserOverviewReqDto reqDto);

    @GetMapping("/userRetention")
    @ApiOperation(value = "用户留存")
    RestResponse<List<UserRetentionRespDto>> userRetention(@Valid UserRetentionReqDto reqDto);
}
