package com.dtyunxi.yundt.cube.center.shop.api;

/**
 * 收款方式
 *
 * @author symo
 * @date 2021/7/20
 */
public enum CollectionTypeEnum {

    /**
     * 商家收款
     */
    SHOP_RECEIVE("SHOP_RECEIVE", "商家收款"),
    ;

    private String code;
    private String name;

    CollectionTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String toName() {
        return name;
    }

    public String toCode() {
        return code;
    }

    public static CollectionTypeEnum fromCode(String code) {
        for (CollectionTypeEnum typeEnum : CollectionTypeEnum.values()) {
            if (typeEnum.toCode().equals(code)) {
                return typeEnum;
            }
        }
        return null;
    }

}
