package com.dtyunxi.yundt.cube.center.shop.api;

/**
 * 发货方式
 *
 * @author symo
 * @date 2021/7/20
 */
public enum DeliverTypeEnum {

    /**
     * 店铺发货
     */
    SHOP_SEND("SHOP_RECEIVE", "店铺发货"),
    ;

    private String code;
    private String name;

    DeliverTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String toName() {
        return name;
    }

    public String toCode() {
        return code;
    }

    public static DeliverTypeEnum fromCode(String code) {
        for (DeliverTypeEnum typeEnum : DeliverTypeEnum.values()) {
            if (typeEnum.toCode().equals(code)) {
                return typeEnum;
            }
        }
        return null;
    }

}
