package com.dtyunxi.yundt.cube.center.shop.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.AuditReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.BizBasicReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author 即墨
 * Date 2021-07-21
 */
@Api(tags = {"店铺中心(F2B2b): 审核"})
@FeignClient(
        contextId = "com.dtyunxi.yundt-b2b-center-shop-api-IAuditExtApi",
        name = "${yundt.cube.center.shop.api.name:yundt-cube-center-shop}",
        url = "${yundt.cube.center.shop.api:}",
        path = "/v2/F2B2b/audit"
)
public interface IAuditExtApi {

    /**
     * 删除审核信息
     *
     * @param reqDto 审核基础对象
     * @return Void
     */
    @DeleteMapping(value = "", produces = "application/json")
    @ApiOperation(value = "删除审核（商家、店铺通用）", notes = "删除（商家、店铺通用）")
    RestResponse<Void> removeAudit(@RequestBody BizBasicReqDto reqDto);


    /**
     * 删除审核信息
     *
     * @param reqDto 审核内容对象
     * @return Void
     */
    @PutMapping(value = "", produces = "application/json")
    @ApiOperation(value = "审核（商家、店铺通用）", notes = "审核（商家、店铺通用）")
    RestResponse<Void> audit(@RequestBody AuditReqDto reqDto);


}
